<?php
include('session_verify.php');
include('db_config.php');
include("report_function.php");
require_once 'vendor/autoload.php';

$P_CUSTOMER_KEY = $login_userkey;

if (isset($_POST["P_LEVEL_KEY"]) && isset($_POST['P_INTAKE_KEY']) && isset($_POST['P_LIT_KEY']))
{
    $P_LEVEL_KEY = $_POST["P_LEVEL_KEY"];
    $P_INTAKE_KEY = $_POST['P_INTAKE_KEY'];
    $P_LIT_KEY = $_POST['P_LIT_KEY'];
}
else
{
    echo "<script type= 'text/javascript'>window.location='main_index.php'</script>";
    exit;
}

$HTML = '<html>
      <head>
      <meta name="robots" content="noindex, nofollow">
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
      <style>
            @page {
                  margin: 0;
            }

            body {
                  margin: 0;
                  font-family: Helvetica, Arial, sans-serif;
            }

            .invoice-box {
                  max-width: 800px;
                  margin: auto;
                  padding: 20px;
                  line-height:normal;
                  color: #000;
                  padding:0px 50px;
            }
            .logo{
                  text-align:center;
            }
            .report_title{
                  font-weight: bold;
                  font-size: 16px;
                  line-height: normal;
                  padding: 10px 0;
            }
            .report_content table{
                  font-size: 12px;
                  line-height:20px;
            }
            .report_content th{
                  text-align: left;
            }
            .report_summry {
                  padding-top: 20px;
            }
            .report_summry table{
                  font-size: 10px;
                  line-height:22px;
                  border: 1px solid #000;
                  border-right: 0px solid #000;
                  width: 100%;
            }
            .report_summry table tr th{
                  padding:3px;
                  border-bottom: 1px solid #000;
                  border-right: 1px solid #000;
            }
            .report_summry table tr td{
                  font-size:10px;
                  padding:3px 8px;
                  text-align:center;
                  border-right: 1px solid #000;
            }

            .report_content_status{
                  padding-top:10px;
                  line-height:10px;
            }
            .report_content_status table{
                  padding-top:10px;
                  font-size:12px;
                  line-height:20px;
            }

            .report_grade_system{
                  padding-top:50px;
            }
            .report_grade_system table{
                  font-size: 10px;
                  line-height:10px;
                  border: 1px solid #000;
                  border-right: 0px solid #000;
            }
            ..report_grade_system table tr th{
                  padding:3px;
                  border-bottom: 1px solid #000;
                  border-right: 1px solid #000;
            }
            .report_grade_system table tr td{
                  font-size:10px;
                  padding:3px 8px;
                  text-align:center;
                  border-right: 1px solid #000;
            }
      </style>
      <title>Tertiary Exam Statement Print</title>
      </head>
      <body>';

//Find the MIN GRADING_KEY for Grading System Display
//Modified by Soon on 18/10/2022 for Finding MIN because previously Programmer do not follow the instruction and find MIN
$sql_min_grading1 = "SELECT MIN(GRADING_KEY) AS GRADING_KEY FROM CUSTOMER_LEVEL_SUBJECT WHERE LIT_KEY = $P_LIT_KEY AND GRADING_KEY IN (SELECT DISTINCT GRADING_KEY
      FROM GRADING_DETAIL WHERE IFNULL(CALCULATION_INCLUDED,'N') = 'Y')";
$res88 = mysqli_query($con,$sql_min_grading1);
$arr88 = mysqli_fetch_assoc($res88);
$GRADINGKEY = $arr88["GRADING_KEY"];

if (is_null($GRADINGKEY))
$GRADINGKEY = 0;

if ($GRADINGKEY == 0)
{
      $sql_min_grading2 = "SELECT MIN(GRADING_KEY) AS RESULT FROM CUSTOMER_LEVEL_SUBJECT WHERE LEVEL_KEY = $P_LEVEL_KEY AND INTAKE_KEY = $P_INTAKE_KEY
            AND GRADING_KEY IN (SELECT DISTINCT GRADING_KEY FROM GRADING_DETAIL WHERE IFNULL(CALCULATION_INCLUDED,'N') = 'Y')";
      $res88 = mysqli_query($con,$sql_min_grading2);
      $arr88 = mysqli_fetch_assoc($res88);
      $GRADINGKEY = $arr88["RESULT"];
}

$sql_a = "SELECT DISTINCT A.CAMPUS, A.CUSTOMER_KEY, A.CUSTOMER_NAME, A.CUSTOMER_NO, A.REFERENCE_NO, A.IC_PASSPORT, 
      C.LEVEL_KEY, C.INTAKE_KEY, C.LIT_KEY, C.LEVEL_CODE, C.INTAKE_NO, C.TERM_NO, F.STUDY_INTAKE, 
      C.CUSTOMER_LIT_KEY, IFNULL(E.CREDIT_CALCULATED,0) CREDIT_CALCULATED, E.TOTAL_GRADING_POINT, E.CUMULATIVE_CREDITS, 
      E.CUMULATIVE_GRADING_POINT, E.GPA, E.CGPA, (CASE IFNULL(E.CREDIT_CALCULATED,0) WHEN 0 THEN 'NOT APPLICABLE' ELSE UPPER(E.ACADEMIC_STATUS)
      END) ACADEMIC_STATUS, UPPER(IFNULL(E.ACADEMIC_AWARDS,' ')) ACADEMIC_AWARDS
      FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_MASTER B, CUSTOMER_LEVEL_DETAILS C, CUSTOMER_LEVEL_SUBJECT D, 
      CUSTOMER_EXAM_RESULT E, TERM_MASTER F
      WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
      AND B.CUSTOMER_KEY = C.CUSTOMER_KEY
      AND B.LEVEL_KEY = C.LEVEL_KEY
      AND B.INTAKE_KEY = C.INTAKE_KEY
      AND C.CUSTOMER_LIT_KEY = D.CUSTOMER_LIT_KEY
      AND C.CUSTOMER_LIT_KEY = E.CUSTOMER_LIT_KEY
      AND E.LIT_KEY = F.LIT_KEY
      AND ((D.CUSTOMER_SUBJECT_STATUS = 'Withdrawn') OR D.EXAM_DATE IN 
      (SELECT DISTINCT X.EXAM_DATE
      FROM EXAM_DATE_SETUP X
      WHERE DATE_FORMAT(IFNULL(X.EXAM_BOARD_DATE, DATE_ADD(NOW(), INTERVAL 1 DAY)), '%Y-%m-%d') <= DATE_FORMAT(NOW(), '%Y-%m-%d')))
      AND D.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Resit', 'Repeat', 'Exempted', 'Withdrawn', 'Completed')
      AND ((C.LEVEL_KEY = $P_LEVEL_KEY)
      AND (C.INTAKE_KEY = $P_INTAKE_KEY)
      AND (C.LIT_KEY = $P_LIT_KEY)
      AND (A.CUSTOMER_KEY = $P_CUSTOMER_KEY OR $P_CUSTOMER_KEY IS NULL))
      ORDER BY C.LEVEL_CODE, C.INTAKE_NO, C.TERM_NO, A.CUSTOMER_NAME";
$result_a = mysqli_query($con,$sql_a)or die(mysqli_error($con));
$i=0;
while($arr_a=mysqli_fetch_assoc($result_a))
{
      $CAMPUS = $arr_a["CAMPUS"];
      $CUSTOMER_KEY = $arr_a["CUSTOMER_KEY"];
      $CUSTOMER_NAME = $arr_a["CUSTOMER_NAME"];
      $CUSTOMER_NO = $arr_a["CUSTOMER_NO"];
      $REFERENCE_NO = $arr_a["REFERENCE_NO"];
      $IC_PASSPORT = $arr_a["IC_PASSPORT"];
      $LEVEL_KEY = $arr_a["LEVEL_KEY"];
      $INTAKE_KEY = $arr_a["INTAKE_KEY"];
      $LIT_KEY = $arr_a["LIT_KEY"];
      $LEVEL_CODE = $arr_a["LEVEL_CODE"];
      $INTAKE_NO = $arr_a["INTAKE_NO"];
      $TERM_NO = $arr_a["TERM_NO"];
      $STUDY_INTAKE = $arr_a["STUDY_INTAKE"];
      $CUSTOMER_LIT_KEY = $arr_a["CUSTOMER_LIT_KEY"];
      $CREDIT_CALCULATED = $arr_a["CREDIT_CALCULATED"];
      $TOTAL_GRADING_POINT = $arr_a["TOTAL_GRADING_POINT"];
      $CUMULATIVE_CREDITS = $arr_a["CUMULATIVE_CREDITS"];
      $CUMULATIVE_GRADING_POINT = $arr_a["CUMULATIVE_GRADING_POINT"];
      $GPA = $arr_a["GPA"];
      $CGPA = $arr_a["CGPA"];
      $ACADEMIC_STATUS = $arr_a["ACADEMIC_STATUS"];
      $ACADEMIC_AWARDS = $arr_a["ACADEMIC_AWARDS"];


      if (strlen($IC_PASSPORT) == 12)
            $IC_PASSPORT_DISPLAY = substr($IC_PASSPORT,0,6).'-'.substr($IC_PASSPORT,6,2).'-'.substr($IC_PASSPORT,8);
      else
            $IC_PASSPORT_DISPLAY = $IC_PASSPORT;


      $sql_semester = "SELECT DISTINCT CONCAT(DATE_FORMAT(TERM_START_DATE,'%M %Y'),' - ',DATE_FORMAT(TERM_END_DATE,'%M %Y')) AS SEMESTER_RANGE
            FROM TERM_MASTER WHERE LIT_KEY = $LIT_KEY";
      $res88 = mysqli_query($con,$sql_semester);
      $arr88 = mysqli_fetch_assoc($res88);
      $SEMESTER_RANGE = $arr88["SEMESTER_RANGE"];

      if ($SEMESTER_RANGE != ' ')
            $SEMESTER_RANGE = 'Semester '.round($TERM_NO).' ( '.$SEMESTER_RANGE.' )';
      else
            $SEMESTER_RANGE = 'Semester '.round($TERM_NO);


      $YEAR_OF_ENTRY = substr($INTAKE_NO,0,4);


      if (substr($STUDY_INTAKE, 4, 2) == '01')
            $STUDY_INTAKE_DISPLAY = 'JANUARY '.substr($STUDY_INTAKE, 0, 4);
      else if (substr($STUDY_INTAKE, 4, 2) == '02')
            $STUDY_INTAKE_DISPLAY = 'FEBRUARY '.substr($STUDY_INTAKE, 0, 4);  
      else if (substr($STUDY_INTAKE, 4, 2) == '03')
            $STUDY_INTAKE_DISPLAY = 'MARCH '.substr($STUDY_INTAKE, 0, 4);  
      else if (substr($STUDY_INTAKE, 4, 2) == '04')
            $STUDY_INTAKE_DISPLAY = 'APRIL '.substr($STUDY_INTAKE, 0, 4);  
      else if (substr($STUDY_INTAKE, 4, 2) == '05')
            $STUDY_INTAKE_DISPLAY = 'MAY '.substr($STUDY_INTAKE, 0, 4);  
      else if (substr($STUDY_INTAKE, 4, 2) == '06')
            $STUDY_INTAKE_DISPLAY = 'JUNE '.substr($STUDY_INTAKE, 0, 4);  
      else if (substr($STUDY_INTAKE, 4, 2) == '07')
            $STUDY_INTAKE_DISPLAY = 'JULY '.substr($STUDY_INTAKE, 0, 4);  
      else if (substr($STUDY_INTAKE, 4, 2) == '08')
            $STUDY_INTAKE_DISPLAY = 'AUGUST '.substr($STUDY_INTAKE, 0, 4);  
      else if (substr($STUDY_INTAKE, 4, 2) == '09')
            $STUDY_INTAKE_DISPLAY = 'SEPTEMBER '.substr($STUDY_INTAKE, 0, 4);  
      else if (substr($STUDY_INTAKE, 4, 2) == '10')
            $STUDY_INTAKE_DISPLAY = 'OCTOBER '.substr($STUDY_INTAKE, 0, 4);  
      else if (substr($STUDY_INTAKE, 4, 2) == '11')
            $STUDY_INTAKE_DISPLAY = 'NOVEMBER '.substr($STUDY_INTAKE, 0, 4);  
      else if (substr($STUDY_INTAKE, 4, 2) == '12')
            $STUDY_INTAKE_DISPLAY = 'DECEMBER '.substr($STUDY_INTAKE, 0, 4);  
      else
            $STUDY_INTAKE_DISPLAY = $STUDY_INTAKE;


      $sql_level_desc = "SELECT DISTINCT LEVEL_DESCRIPTION FROM LEVEL_MASTER WHERE LEVEL_KEY = $LEVEL_KEY";
      $res88 = mysqli_query($con,$sql_level_desc);
      $arr88 = mysqli_fetch_assoc($res88);
      $LEVEL_DESCRIPTION = $arr88["LEVEL_DESCRIPTION"];


      $sql_term_credit = "SELECT SUM(ALL SUBJECT_CREDITS) AS RESULT FROM CUSTOMER_LEVEL_SUBJECT WHERE CUSTOMER_LIT_KEY = $CUSTOMER_LIT_KEY
            AND SUBJECT_ORIGINAL_STATUS IN ('Active', 'Resit', 'Repeat') AND CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Resit', 'Repeat')
            AND SUBJECT_GRADE <> 'In' AND SUBJECT_CODE NOT LIKE 'IVY%' AND SUBJECT_CODE NOT LIKE 'ICDL%'";
      $res88 = mysqli_query($con,$sql_term_credit);
      $arr88 = mysqli_fetch_assoc($res88);
      $TERM_CREDIT = $arr88["RESULT"];


      if ($LEVEL_CODE == "ADTP")
      {
            $sql_overall_credit = "SELECT SUM(ALL SUBJECT_CREDITS) AS RESULT FROM CUSTOMER_LEVEL_SUBJECT WHERE CUSTOMER_KEY = $CUSTOMER_KEY
                  AND LEVEL_KEY = $LEVEL_KEY AND INTAKE_KEY = $INTAKE_KEY AND TERM_NO <= $TERM_NO AND SUBJECT_GRADE <> 'In'
                  AND SUBJECT_ORIGINAL_STATUS IN ('Active', 'Exempted') AND CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Exempted')
                  AND SUBSTR(SUBJECT_CODE,1,3) NOT IN ('MPU', 'MPW', 'LAN', 'GEN') AND SUBJECT_CODE NOT LIKE 'IVY%' AND SUBJECT_CODE NOT LIKE 'ICDL%'";
            $res88 = mysqli_query($con,$sql_overall_credit);
            $arr88 = mysqli_fetch_assoc($res88);
            $OVERALL_CREDIT = $arr88["RESULT"];
      }
      else
      {
            $sql_overall_credit = "SELECT SUM(ALL SUBJECT_CREDITS) AS RESULT FROM CUSTOMER_LEVEL_SUBJECT WHERE CUSTOMER_KEY = $CUSTOMER_KEY
                  AND LEVEL_KEY = $LEVEL_KEY AND INTAKE_KEY = $INTAKE_KEY AND TERM_NO <= $TERM_NO AND SUBJECT_GRADE <> 'In' AND SUBJECT_ORIGINAL_STATUS IN ('Active', 'Exempted') AND CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Exempted') AND SUBJECT_CODE NOT LIKE 'IVY%' AND SUBJECT_CODE NOT LIKE 'ICDL%'";
            $res88 = mysqli_query($con,$sql_overall_credit);
            $arr88 = mysqli_fetch_assoc($res88);
            $OVERALL_CREDIT = $arr88["RESULT"];
      }


      if ($CREDIT_CALCULATED == 0)
            $GPA_DISPLAY = 'N/A';
      else
            $GPA_DISPLAY = $GPA;


      if ($ACADEMIC_AWARDS == ' ')
            $ACADEMIC_AWARDS_DISPLAY = '-';
      else
            $ACADEMIC_AWARDS_DISPLAY = $ACADEMIC_AWARDS;

      $HTML_REPORT_SUMMERY = '';
      $V_RUNNING = 1;
      $sql_b = "SELECT DISTINCT D.SUBJECT_KEY, D.SUBJECT_CODE, D.SUBJECT_DESCRIPTION, D.SUBJECT_GRADE, D.GRADING_POINT, D.SUBJECT_CREDITS, 
            (CASE IFNULL(D.GRADING_POINT,-999) WHEN '-999' THEN CONCAT('ZZ', D.SUBJECT_CODE) ELSE CONCAT('AA', D.SUBJECT_CODE)
            END) SUBJECT_ORDER, 
            D.SUBJECT_GRADING_POINT, D.GRADING_KEY, D.CUSTOMER_SUBJECT_STATUS, D.SUBJECT_ORIGINAL_STATUS,
            D.CUSTOMER_LIT_SUBJECT_KEY
            FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_MASTER B, CUSTOMER_LEVEL_DETAILS C, CUSTOMER_LEVEL_SUBJECT D, 
            CUSTOMER_EXAM_RESULT E, TERM_MASTER F
            WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
            AND B.CUSTOMER_KEY = C.CUSTOMER_KEY
            AND B.LEVEL_KEY = C.LEVEL_KEY
            AND B.INTAKE_KEY = C.INTAKE_KEY
            AND C.CUSTOMER_LIT_KEY = D.CUSTOMER_LIT_KEY
            AND C.CUSTOMER_LIT_KEY = E.CUSTOMER_LIT_KEY
            AND E.LIT_KEY = F.LIT_KEY
			AND D.SUBJECT_CODE NOT LIKE 'IVY%'
			AND D.SUBJECT_CODE NOT LIKE 'ICDL%'
            AND ((D.CUSTOMER_SUBJECT_STATUS = 'Withdrawn') OR D.EXAM_DATE IN (SELECT DISTINCT X.EXAM_DATE FROM EXAM_DATE_SETUP X
            WHERE DATE_FORMAT(IFNULL(X.EXAM_BOARD_DATE, DATE_ADD(NOW(), INTERVAL 1 DAY)), '%Y-%m-%d') <= DATE_FORMAT(NOW(), '%Y-%m-%d')))
            AND D.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Resit', 'Repeat', 'Exempted', 'Withdrawn', 'Completed')
            AND C.CUSTOMER_LIT_KEY = $CUSTOMER_LIT_KEY
            ORDER BY SUBJECT_ORDER";
      $result_b = mysqli_query($con,$sql_b)or die(mysqli_error($con));
      while($arr_b=mysqli_fetch_assoc($result_b))
      {
            $SUBJECT_KEY = $arr_b["SUBJECT_KEY"];
            $SUBJECT_CODE = $arr_b["SUBJECT_CODE"];
            $SUBJECT_DESCRIPTION = $arr_b["SUBJECT_DESCRIPTION"];
            $SUBJECT_GRADE = $arr_b["SUBJECT_GRADE"];
            $GRADING_POINT = $arr_b["GRADING_POINT"];
            $SUBJECT_CREDITS = $arr_b["SUBJECT_CREDITS"];
            $SUBJECT_GRADING_POINT = $arr_b["SUBJECT_GRADING_POINT"];
            $GRADING_KEY = $arr_b["GRADING_KEY"];
            $CUSTOMER_SUBJECT_STATUS = $arr_b["CUSTOMER_SUBJECT_STATUS"];
            $SUBJECT_ORIGINAL_STATUS = $arr_b["SUBJECT_ORIGINAL_STATUS"];
            $CUSTOMER_LIT_SUBJECT_KEY = $arr_b["CUSTOMER_LIT_SUBJECT_KEY"];

            //To find what to display as GRADE
            if ($CUSTOMER_SUBJECT_STATUS == 'Withdrawn' || $CUSTOMER_SUBJECT_STATUS == 'Exempted')
            {
                  if ($CUSTOMER_SUBJECT_STATUS == 'Withdrawn')
                        $GRADE = 'W';
                  else
                        $GRADE = 'EX';
            }
            else
            {
                  $sql_chk1 = "SELECT COUNT(*) AS V_CHK1 FROM CUSTOMER_EXAM_MASTER WHERE CUSTOMER_LIT_SUBJECT_KEY = $CUSTOMER_LIT_SUBJECT_KEY AND IFNULL(EXAM_MARKS,-999) = -999";
                  $res88 = mysqli_query($con,$sql_chk1);
                  $arr88 = mysqli_fetch_assoc($res88);
                  $V_CHK1 = $arr88["V_CHK1"];

                  $sql_chk2 = "SELECT COUNT(*) AS V_CHK2 FROM CUSTOMER_EXAM_DETAIL WHERE CUSTOMER_LIT_SUBJECT_KEY = $CUSTOMER_LIT_SUBJECT_KEY AND IFNULL(EXAM_MARKS,-999) = -999";
                  $res88 = mysqli_query($con,$sql_chk2);
                  $arr88 = mysqli_fetch_assoc($res88);
                  $V_CHK2 = $arr88["V_CHK2"];

                  $V_CHK = $V_CHK1 + $V_CHK2;

                  if ($V_CHK != 0)
                  {
                        $GRADE = 'IN';
                  }
                  else
                  {
                        if ($SUBJECT_ORIGINAL_STATUS == 'Repeat')
                        {
                              $sql_chk3 = "SELECT COUNT(*) AS V_CHK3 FROM CUSTOMER_LEVEL_SUBJECT WHERE CUSTOMER_KEY = $CUSTOMER_KEY AND LEVEL_KEY = $LEVEL_KEY AND INTAKE_KEY = $INTAKE_KEY AND TERM_NO <= $TERM_NO AND SUBJECT_KEY = $SUBJECT_KEY AND SUBJECT_ORIGINAL_STATUS IN ('Resit', 'Repeat')";
                              $res88 = mysqli_query($con,$sql_chk3);
                              $arr88 = mysqli_fetch_assoc($res88);
                              $V_CHK3 = $arr88["V_CHK3"];

                              $GRADE = $SUBJECT_GRADE.' (R'.$V_CHK3.')';
                        }
                        else
                        {
                              $GRADE = $SUBJECT_GRADE;
                        }
                  }
            }

            //To Find the POINT
            $sql_include_calculation = "SELECT DISTINCT CALCULATION_INCLUDED FROM GRADING_DETAIL WHERE GRADING_KEY = $GRADING_KEY AND GRADING_GRADE = '$SUBJECT_GRADE'";
            $res88 = mysqli_query($con,$sql_include_calculation);
            $arr88 = mysqli_fetch_assoc($res88);
            $INCLUDE_CALCULATION = $arr88["CALCULATION_INCLUDED"];

            if($INCLUDE_CALCULATION == 'N')
            {
                  $POINT = " ";
                  $GRADE_POINT = " ";
            }
            else
            {
                  if ($GRADE == 'W' || $GRADE == 'EX' || $GRADE == 'IN')
                  {
                        $POINT = " ";
                        $GRADE_POINT = " ";
                  }
                  else
                  {
                        $POINT = $GRADING_POINT;
                        $GRADE_POINT = $SUBJECT_GRADING_POINT;
                  }
            }

            $HTML_REPORT_SUMMERY .= '<tr>
                  <td>'.$SUBJECT_CODE.'</td>
                  <td style="text-align:lft;">'.$SUBJECT_DESCRIPTION.'</td>
                  <td>'.$GRADE.'</td>
                  <td>'.number_format($POINT,2).'</td>
                  <td>'.$SUBJECT_CREDITS.'</td>
                  <td class="b-r0">'.number_format($GRADE_POINT,2).'</td>
            </tr>';

            $V_RUNNING++;
      }

      $HTML_REPORT_SUMMERY_FOOTER = '';
      $V_RUNNING++;
      for ($x = $V_RUNNING; $x <= 10; $x++) 
      {
            $HTML_REPORT_SUMMERY_FOOTER .= '<tr>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td class="b-r0">&nbsp;</td>
            </tr> ';
      }

      $HTML_REPORT_GRADE_SYSTEM = "";
      $sql_c = "SELECT DISTINCT GRADING_MARK_FROM, GRADING_MARK_TO, GRADING_GRADE, GRADING_POINT, GRADING_CODE
            FROM GRADING_DETAIL
            WHERE GRADING_KEY = $GRADINGKEY
            AND GRADING_GRADE <> 'In'
            ORDER BY GRADING_MARK_TO DESC";

      $HTML_REPORT_GRADE_SYSTEM .='<table cellspacing="0" cellpadding="5" style="border-bottom:0px solid #000;"><tbody>';

      for ($x = 1; $x <= 2; $x++) 
      {
            if ($x == 1)
                  $FIRST_COLUMN = "GRADE";
            else
                  $FIRST_COLUMN = "GRADE POINT";

            $HTML_REPORT_GRADE_SYSTEM .='<tr><th style="border-bottom:1px solid #000; border-right:1px solid #000;width:90px;">'.$FIRST_COLUMN.'</th>';

            $result_c = mysqli_query($con,$sql_c)or die(mysqli_error($con));
            while($arr_c=mysqli_fetch_assoc($result_c))
            {
                  $M_GRADING_MARK_FROM = $arr_c["GRADING_MARK_FROM"];
                  $M_GRADING_MARK_TO = $arr_c["GRADING_MARK_TO"];
                  $M_GRADING_GRADE = $arr_c["GRADING_GRADE"];
                  $M_GRADING_POINT = $arr_c["GRADING_POINT"];
                  $M_GRADING_CODE = $arr_c["GRADING_CODE"];

                  if ($x == 1)
                  $DISPLAY_COLUMN = $M_GRADING_GRADE;
                  else
                  $DISPLAY_COLUMN = number_format($M_GRADING_POINT,2);

                  $HTML_REPORT_GRADE_SYSTEM .='<td style="border-bottom:1px solid #000; border-right:1px solid #000;width:40px;">'.$DISPLAY_COLUMN.'</td>';
            }
            $HTML_REPORT_GRADE_SYSTEM .='</tr>';
      }
      $HTML_REPORT_GRADE_SYSTEM .='</tbody></table>';

      $PageBrake = '';
      if($i!=0){
            $PageBrake .= '<div style="page-break-before:always;">&nbsp;</div>';
      }
      $Style  = '';
      if($i==0){
          $Style = 'padding-top:20px;'; 
      }
      $i++;
      
      if ($CAMPUS == 'MCKL')
            $LOGO_IMAGE = 'MCKL_Logo1.png';
      else
            $LOGO_IMAGE = 'MCKL_Logo2.png';

      $HTML .= $PageBrake.'<div class="invoice-box" style="'.$Style.'">
            <div style="width:100%;">
                  <div class="logo">
                        <img src="Image/'.$LOGO_IMAGE.'" style="width:100%; max-width:220px; margin-right:0px;">
                  </div>
                  <div class="report_title">
                        <span>STATEMENT OF SEMESTER RESULTS - '.$STUDY_INTAKE_DISPLAY.'</span>
                  </div>
            </div>                   
            <div style="width:100%;" class="report_content">
                  <table style="width:100%;" cellspacing="0" cellpadding="0">
                        <tr>
                              <th style="width:150px;">Program</th>
                              <td style="width:10px;">:</td>
                              <td>'.$LEVEL_DESCRIPTION.'</td>
                        </tr>
                        <tr>
                              <th>Name of Student</th>
                              <td>:</td>
                              <td>'.$CUSTOMER_NAME.'</td>
                        </tr>
                        <tr>
                              <th>NRIC/Passport</th>
                              <td>:</td>
                              <td>'.$IC_PASSPORT_DISPLAY.'</td>
                        </tr>
                        <tr>
                              <th>Student ID.</th>
                              <td>:</td>
                              <td>'.$CUSTOMER_NO.' ( '.$REFERENCE_NO.' )</td>
                        </tr>
                        <tr>
                              <th>Semester</th>
                              <td>:</td>
                              <td>'.$SEMESTER_RANGE.'</td>
                        </tr>
                        <tr>
                              <th>Year of Entry</th>
                              <td>:</td>
                              <td>'.$YEAR_OF_ENTRY.'</td>
                        </tr>
                  </table>
            </div>

            <div style="width:100%;" class="report_summry">
                  <table cellspacing="0" cellpadding="0">
                        <thead>
                              <tr>
                                    <th style="width:70px;">CODE</th>
                                    <th>COURSE DESCRIPTION</th>
                                    <th style="width:70px;">GRADE</th>
                                    <th style="width:70px;">POINT</th>
                                    <th  style="width:100px;" class="b-r0">CREDIT HOURS</th>
                                    <th  style="width:100px;" class="b-r0">GRADE POINT</th>
                              </tr>
                        </thead>                                    
                        <tbody>
                              '.$HTML_REPORT_SUMMERY.'
                              <tr>
                                    <td></td>
                                    <td style="text-align:left;font-style:italic;">******End of Results******</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td class="b-r0"></td>
                              </tr>
                              '.$HTML_REPORT_SUMMERY_FOOTER.'                                          
                              <tr>
                                    <td colspan="4" style="text-align:right;border-top: 1px solid #000;">TOTAL CREDIT :</td>
                                    <td style="border-top: 1px solid #000;">'.number_format($TERM_CREDIT).'</td>
                                    <td class="b-r0" style="border-top: 1px solid #000;">'.number_format($TOTAL_GRADING_POINT,2).'</td>
                              </tr>
                              <tr>
                                    <td colspan="4" style="text-align:right;border-top: 1px solid #000;">TOTAL CREDIT ACCUMULATED :</td>
                                    <td style="border-top: 1px solid #000;">'.number_format($OVERALL_CREDIT).'</td>
                                    <td class="b-r0" style="border-top: 1px solid #000;">'.number_format($CUMULATIVE_GRADING_POINT,2).'</td>
                              </tr>
                              <tr>
                                    <td colspan="4" style="border-top: 1px solid #000;"></td>
                                    <td style="border-top: 1px solid #000;text-align:right;">GPA:</td>
                                    <td class="b-r0" style="border-top: 1px solid #000;">'.number_format($GPA_DISPLAY,2).'</td>
                              </tr>
                              <tr>
                                    <td colspan="4" style="border-top: 1px solid #000;"></td>
                                    <td style="border-top: 1px solid #000;text-align:right;">CGPA:</td>
                                    <td class="b-r0" style="border-top: 1px solid #000;">'.number_format($CGPA,2).'</td>
                              </tr>
                        </tbody>                                    
                  </table>
            </div>

            <div class="report_content_status">
                  <table cellspacing="0" cellpadding="0">
                        <tbody>
                              <tr>
                                    <td style="width:70px;">STATUS</td><td style="width:12px;">:</td><td>'.$ACADEMIC_STATUS.'</td>
                              </tr>
                              <tr>
                                    <td>AWARDS</td><td style="width:12px;">:</td><td>'.$ACADEMIC_AWARDS_DISPLAY.'</td>
                              </tr>
                        </tbody>
                  </table>
            </div>

            <div class="report_grade_system">
                  <span style="font-weight:bold;font-size:12px;">GRADING SYSTEM</span> 
                  '.$HTML_REPORT_GRADE_SYSTEM.'

                  <table cellspacing="0" cellpadding="5" style="margin-top:10px;line-height:10px;">
                        <tbody>
                              <tr>
                                    <th style="border-bottom:1px solid #000; border-right:1px solid #000;width:90px;">GRADE</th>
                                    <td style="border-bottom:1px solid #000; border-right:1px solid #000;width:80px;">(R) Repeat</td>
                                    <td style="border-bottom:1px solid #000; border-right:1px solid #000;width:80px;">P (Pass)</td>
                                    <td style="border-bottom:1px solid #000; border-right:1px solid #000;width:80px;">F (Fail)</td>
                                    <td style="border-bottom:1px solid #000; border-right:1px solid #000;width:80px;">W</td>
                                    <td style="border-bottom:1px solid #000; border-right:1px solid #000;width:80px;">AB</td>
                                    <td style="border-bottom:1px solid #000; border-right:1px solid #000;width:80px;">IN</td>
                                    <td style="border-bottom:1px solid #000; border-right:1px solid #000;width:80px;">EX</td>
                              </tr>
                              <tr>
                                    <th style="border-right:1px solid #000;width:90px;">GRADE POINT</th>
                                    <td style="border-right:1px solid #000;width:80px;">Repeat</td>
                                    <td style="border-right:1px solid #000;width:80px;">Not Assigned</td>
                                    <td style="border-right:1px solid #000;width:80px;">Not Assigned</td>
                                    <td style="border-right:1px solid #000;width:80px;">Dropped</td>
                                    <td style="border-right:1px solid #000;width:80px;">Absent</td>
                                    <td style="border-right:1px solid #000;width:80px;">Incomplete</td>
                                    <td style="border-right:1px solid #000;width:80px;">Exempted</td>
                              </tr>
                        </tbody>
                  </table>
            </div>
      </div>';
}

$HTML .= '</body></html>';

/*$footerdata = '<div style="margin:auto; width:100%;padding:10px 50px;font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif;font-size: 10px;">
            <div style="font-style: italic;text-align:left;inline-block;">
              <div style="width:50%;float:left;">Computer Generated - Signature not required.</div>
              <div style="width:50%;float:right;text-align:right;">Please file safely for your record.</div>
            </div>
      </div>';*/
$footerdata = '<div style="margin:0px auto; width:100%;font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif;font-size: 10px;">
            <div style="font-style: italic;text-align:center;padding-bottom:15px;">
              Computer Generated - Signature not required.
			  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			  Please file safely for your record.
            </div>
      </div>';
//echo $html;exit;


//Added by Soon on 30/03/2020
//Make the Report Name more meaningful, else all report same name
//$reportname = $LEVEL_CODE."-".$INTAKE_NO."-".number_format($TERM_NO).".pdf";
$report_name = preg_replace('/[^a-zA-Z0-9_ -]/s', '', $CUSTOMER_NAME).".pdf";

$mpdf = new \Mpdf\Mpdf(['mode' => 'utf-8', 'format' => 'A4','0','',0,0,0,0,'margin_header' => 0,'orientation' => 'P']);
$mpdf->setAutoTopMargin = 'stretch';
$mpdf->setAutoBottomMargin = 'stretch'; 
$mpdf->AddPage('P','','','','',' ',' ',' ',' ',0,0);
$mpdf->SetHTMLFooter($footerdata);
$mpdf->WriteHTML($HTML);
$mpdf->SetProtection(array('print','print-highres'),'','[]mckl@0322741851&mcpg#042175088()');
$mpdf->Output($report_name,"I");
exit;
?>