<?php
$page = "profile";
include('session_verify.php');
include('portal_header.php');
?>
<title>Student Information</title>
<!-- Extra Css Or Special Design -->

<style>
    th {
        background-color: blue;
        /* color: black; */
    }

    .normal-text-bg {
        font-weight: normal;
        font-size: 20px;
    }

    .lg-title {
        font-size: 26px;
    }
</style>

<?php
include('portal_navbar.php');
include('db_config.php');
$sql = mysqli_query($con, "SELECT DISTINCT CUSTOMER_NAME, IC_PASSPORT, CUSTOMER_NO, REFERENCE_NO, DATE_FORMAT(DATE_OF_BIRTH, '%d-%m-%Y') DATE_OF_BIRTH, GENDER, 
        CUSTOMER_OWN_EMAIL, CUSTOMER_MOBILE_NO, RACE, RELIGION, NATIONALITY, SCHOLAR_SPONSOR_KEY, 
        SCHOLAR_SPONSOR_CODE, SCHOLARSHIP_TYPE, SCHOLARSHIP_PERCENT, SCHOLAR_STATUS
        FROM CUSTOMER_INFO
        WHERE CUSTOMER_KEY = $login_userkey");
$res_sql = mysqli_fetch_assoc($sql);
$SCHOLAR_STATUS = $res_sql['SCHOLAR_STATUS'];
$SCHOLARSHIP_TYPE = $res_sql['SCHOLARSHIP_TYPE'];

if ($SCHOLAR_STATUS == "Applying" || $SCHOLAR_STATUS == "Confirmed" || $SCHOLAR_STATUS == "Offered") {
    $SCHOLAR_STATUS_DISPLAY = $SCHOLAR_STATUS;
} else {
    $SCHOLAR_STATUS_DISPLAY = "N/A";
}
if ($res_sql['SCHOLARSHIP_PERCENT'] != "" && $res_sql['SCHOLARSHIP_PERCENT'] != null) {
    $SCHOLARSHIP_PERCENT = " (" . $res_sql['SCHOLARSHIP_PERCENT'] . ")";
} else {
    $SCHOLARSHIP_PERCENT = "";
}

if ($SCHOLARSHIP_TYPE == "" || $SCHOLARSHIP_TYPE == " " || $SCHOLARSHIP_TYPE == null)
{
    $SCHOLARSHIP_DISPLAY = "N/A";
}
else
{
    $SCHOLARSHIP_DISPLAY = $SCHOLARSHIP_TYPE.$SCHOLARSHIP_PERCENT;
}

$sql_visa = mysqli_query($con, "SELECT DISTINCT INSURANCE_TYPE, VISA_TYPE, DATE_FORMAT(VISA_EXPIRES_DATE, '%Y-%m-%d') VISA_EXPIRES_DATE
        FROM CUSTOMER_INFO
        WHERE CUSTOMER_KEY = $login_userkey");
$res_visa = mysqli_fetch_assoc($sql_visa);

$sql_address = mysqli_query($con, "SELECT DISTINCT ADDRESS_LINE1, ADDRESS_LINE2, ADDRESS_POSTCODE, ADDRESS_CITY_TOWN, ADDRESS_STATE, ADDRESS_COUNTRY
        FROM CUSTOMER_ADDRESS_DETAIL
        WHERE CUSTOMER_KEY = $login_userkey
        AND CUSTOMER_ADDRESS_TYPE = 'Correspondence'");
if (mysqli_num_rows($sql_address) > 0) {
    $res_address = mysqli_fetch_assoc($sql_address);
    $address = "";
    if ($res_address['ADDRESS_LINE1'] != "" || $res_address['ADDRESS_LINE1'] != null) {
        $address .= $res_address['ADDRESS_LINE1'] . "<br/>";
    }
    if ($res_address['ADDRESS_LINE2'] != "" || $res_address['ADDRESS_LINE2'] != null) {
        $address .= $res_address['ADDRESS_LINE2'] . "<br/>";
    }

    if ($res_address['ADDRESS_POSTCODE'] != "" || $res_address['ADDRESS_POSTCODE'] != null) {
        if ($res_address['ADDRESS_CITY_TOWN'] != "" || $res_address['ADDRESS_CITY_TOWN'] != null) {
            $address .= $res_address['ADDRESS_POSTCODE'] . ", " . $res_address['ADDRESS_CITY_TOWN'] . "<br/>";
        } else {
            $address .= $res_address['ADDRESS_POSTCODE'] . "<br/>";
        }
    } else {
        if ($res_address['ADDRESS_CITY_TOWN'] != "" || $res_address['ADDRESS_CITY_TOWN'] != null) {
            $address .= $res_address['ADDRESS_CITY_TOWN'] . "<br/>";
        } else {
        }
    }
    if ($res_address['ADDRESS_STATE'] != "" || $res_address['ADDRESS_STATE'] != null) {
        if ($res_address['ADDRESS_COUNTRY'] != "" || $res_address['ADDRESS_COUNTRY'] != null) {
            $address .= $res_address['ADDRESS_STATE'] . ", " . $res_address['ADDRESS_COUNTRY'] . "<br/>";
        } else {
            $address .= $res_address['ADDRESS_STATE'] . "<br/>";
        }
    } else {
        if ($res_address['ADDRESS_COUNTRY'] != "" || $res_address['ADDRESS_COUNTRY'] != null) {
            $address .= $res_address['ADDRESS_COUNTRY'] . "<br/>";
        } else {
        }
    }
} else {
    $address = "<i>No information provided, please contact Office of Registry.</i>";
}
$sql_parent = mysqli_query($con, "SELECT DISTINCT RELATIONSHIP, PARENT_NAME, EMAIL_ADDRESS, MOBILE_NO
        FROM CUSTOMER_PARENT_INFO
        WHERE CUSTOMER_KEY = $login_userkey
        ORDER BY RELATIONSHIP, PARENT_NAME");
if (mysqli_num_rows($sql_parent) > 0) {
    $parent_data = "";
    while ($res_parent = mysqli_fetch_assoc($sql_parent)) {
        $RELATIONSHIP = $res_parent['RELATIONSHIP'];
        $PARENT_NAME = $res_parent['PARENT_NAME'];
        $EMAIL_ADDRESS = $res_parent['EMAIL_ADDRESS'];
        $MOBILE_NO = $res_parent['MOBILE_NO'];
        if ($PARENT_NAME == "" || $PARENT_NAME == null) {
            $PARENT_NAME = "<i>No information provided, please contact Office of Registry.</i>";
        }
        if ($EMAIL_ADDRESS == "" || $EMAIL_ADDRESS == null) {
            $EMAIL_ADDRESS = "<i>No information provided, please contact Office of Registry.</i>";
        }
        if ($MOBILE_NO == "" || $MOBILE_NO == null) {
            $MOBILE_NO = "<i>No information provided, please contact Office of Registry.</i>";
        }
        $parent_data .= '<tr class="table-primary">
        <td><span class="lg-title"><b>' . $RELATIONSHIP . '</b></span></td>
    </tr>
    <tr>
        <td><b>Name : </b><br /><span class="normal-text-bg">' . $PARENT_NAME . '</span></td>
    </tr>
    <tr>
        <td><b>Email : </b><br /><span class="normal-text-bg">' . $EMAIL_ADDRESS . '</span></td>
    </tr>
    <tr>
        <td><b>Mobile Number : </b><br /><span class="normal-text-bg">' . $MOBILE_NO . '</span></td>
    </tr>';
    }
} else {
    $parent_data = '<tr class="table-primary">
    <td><span class="lg-title"><b>Parent Information</b></span></td>
</tr><tr>
    <td><span class="normal-text-bg"><i>No information provided, please contact Office of Registry.</i></span></td>
</tr>';
}
?>

<!-- Content Here -->
<div class="container">
    <br />
    <div class="container-fluid">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Student Infomation</h3>
                    </div>

                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr class="table-primary">
                                    <th><span class="lg-title"><b>Personal Infomation</b></span></th>
                                </tr>

                            </thead>
                            <tbody>
                                <tr>
                                    <td><b>Full Name : </b><br /><span class="normal-text-bg"><?php echo $res_sql['CUSTOMER_NAME'] ? $res_sql['CUSTOMER_NAME'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>NRIC / Passport : </b><br /><span class="normal-text-bg"><?php echo $res_sql['IC_PASSPORT'] ? $res_sql['IC_PASSPORT'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>Student ID : </b><br /><span class="normal-text-bg"><?php echo $res_sql['CUSTOMER_NO'] ? $res_sql['CUSTOMER_NO'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>Admission No : </b><br /><span class="normal-text-bg"><?php echo $res_sql['REFERENCE_NO'] ? $res_sql['REFERENCE_NO'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>Date of Birth : </b><br /><span class="normal-text-bg"><?php echo $res_sql['DATE_OF_BIRTH'] ? $res_sql['DATE_OF_BIRTH'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>Gender : </b><br /><span class="normal-text-bg"><?php echo $res_sql['GENDER'] ? $res_sql['GENDER'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>Personal Email Address : </b><br /><span class="normal-text-bg"><?php echo $res_sql['CUSTOMER_OWN_EMAIL'] ? $res_sql['CUSTOMER_OWN_EMAIL'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>Personal Mobile Number : </b><br /><span class="normal-text-bg"><?php echo $res_sql['CUSTOMER_MOBILE_NO'] ? $res_sql['CUSTOMER_MOBILE_NO'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>Race : </b><br /><span class="normal-text-bg"><?php echo $res_sql['RACE'] ? $res_sql['RACE'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>Religion : </b><br /><span class="normal-text-bg"><?php echo $res_sql['RELIGION'] ? $res_sql['RELIGION'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>Nationality : </b><br /><span class="normal-text-bg"><?php echo $res_sql['NATIONALITY'] ? $res_sql['NATIONALITY'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                </tr>
                                <tr class="table-primary">
                                    <td><span class="lg-title"><b>Scholarship Information</b></span></td>
                                </tr>
                                <tr>
                                    <td><b>Type : </b><br /><span class="normal-text-bg"><?php echo $SCHOLARSHIP_DISPLAY ?></span></td>
                                </tr>
                                <tr>
                                    <td><b>Status : </b><br /><span class="normal-text-bg"><?php echo $SCHOLAR_STATUS_DISPLAY ?></span></td>
                                </tr>
                                <table class="table table-bordered">
                                    <tr>
                                        <th>Scholarship Status</th>
                                        <th>Legend</th>
                                    </tr>
                                    <tr>
                                        <td>N/A</td>
                                        <td>No scholarship. If you are supposed to be on a scholarship, please contact the Office of the Registrar immediately</td>
                                    </tr>
                                    <tr>
                                        <td>Applying</td>
                                        <td>Kindly wait for the Scholarship Offer to be sent to your email</td>
                                    </tr>
                                    <tr>
                                        <td>Offered</td>
                                        <td>Check your email for the Scholarship Offer and submit the Scholarship Acceptance immediately</td>
                                    </tr>
                                    <tr>
                                        <td>Confirmed</td>
                                        <td>The scholarship has been confirmed and no further action necessary</td>
                                    </tr>
                                </table>
                                <i>**Disclaimer: The information shown is correct at the time of printing/viewing (<?php echo date('d F Y h:i:s a', time()) ?>)**</i>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card -->
                <br />
                <?php
                if ($res_sql['NATIONALITY'] != "Malaysia" && $res_sql['NATIONALITY'] != "Malaysian") {
                    //Show the Visa Information Part

                ?>

                    <div class="card ">
                        <div class="card-header">
                            <h3 class="card-title">Visa Information</h3>
                        </div>

                        <div class="card-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr class="table-primary">
                                        <th><span class="lg-title"><b>Visa Infomation</b></span></th>
                                    </tr>

                                </thead>
                                <tbody>
                                    <tr>
                                        <td><b>Insurance Type : </b><br /><span class="normal-text-bg"><?php echo $res_visa['INSURANCE_TYPE'] ? $res_visa['INSURANCE_TYPE'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                    </tr>
                                    <tr>
                                        <td><b>Type of Visa : </b><br /><span class="normal-text-bg"><?php echo $res_visa['VISA_TYPE'] ? $res_visa['VISA_TYPE'] : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                    </tr>
                                    <tr>
                                        <td><b>Visa Expiry Date : </b><br /><span class="normal-text-bg"><?php echo date_format(date_create($res_visa['VISA_EXPIRES_DATE']), "Y-m-d") ? date_format(date_create($res_visa['VISA_EXPIRES_DATE']), "Y-m-d") : '<i>No information provided, please contact Office of Registry.</i>' ?></span></td>
                                    </tr>

                                </tbody>
                            </table>
                            <i>**Disclaimer: The information shown is correct at the time of printing/viewing (<?php echo date('d F Y h:i:s a', time()) ?>)**</i>
                        </div>
                    </div>
                    <br />
                <?php
                } else {
                    //Hide the Visa Information Part
                }
                ?>
                <div class="card ">
                    <div class="card-header">
                        <h3 class="card-title">Address Information</h3>
                    </div>

                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr class="table-primary">
                                    <th><span class="lg-title"><b>Address Information</b></span></th>
                                </tr>

                            </thead>
                            <tbody>
                                <tr>
                                    <td><b>Address Detail : </b><br /><span class="normal-text-bg"><?php echo $address ?></span></td>
                                </tr>
                            </tbody>
                        </table>
                        <i>**Disclaimer: The information shown is correct at the time of printing/viewing (<?php echo date('d F Y h:i:s a', time()) ?>)**</i>
                    </div>
                </div>
                <br />
                <div class="card ">
                    <div class="card-header">
                        <h3 class="card-title">Parent Information</h3>
                    </div>

                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                            </thead>
                            <tbody>
                                <?php
                                echo $parent_data;

                                ?>
                            </tbody>
                        </table>
                        <i>**Disclaimer: The information shown is correct at the time of printing/viewing (<?php echo date('d F Y h:i:s a', time()) ?>)**</i>
                    </div>
                </div>
                <br />
            </div>
            <!--/.col (left) -->
        </div>
        <!-- /.row -->

    </div>
</div>

<?php
include('portal_footer.php');
?>