<?php
//session_start();
ini_set('max_execution_time', 1500); //300 seconds = 5 minutes
ini_set('max_execution_time', 0); //0=NOLIMIT
ini_set('memory_limit', '1024M');
ini_set("pcre.backtrack_limit", "50000000");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('session_verify.php');
include('db_config.php');
include("report_function.php");
require_once 'vendor/autoload.php';

$CUSTOMER_KEY = $login_userkey;

if (isset($_POST["P_LEVEL_KEY"]) && isset($_POST['P_STUDY_INTAKE']))
{
    $LEVEL_KEY = $_POST["P_LEVEL_KEY"];
    $STUDY_INTAKE = $_POST['P_STUDY_INTAKE'];
}
else
{
    echo "<script type= 'text/javascript'>window.location='main_index.php'</script>";
    exit;
}

$html = '<html><head><meta name="robots" content="noindex, nofollow"><meta http-equiv="Content-Type" content="text/html; charset=utf-8"><title>Student Exam Docket Print</title>
    <style>
      @page {
          margin:0;
      }
      body {
          margin: 0;
      }
      .invoice-box {
          max-width: 800px;
          margin: auto;
          padding: 0 10px;
          font-size: 11pt;
          line-height: 12pt;
          font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif;
          color: #000;
      }

      .invoice-box table {
          width: 100%;
          line-height: 11pt;
          text-align: left;
      }
      
      .invoice-box table td {
          padding: 5px;
          vertical-align: middle;
      }
      
      .invoice-box table tr td.paddingY,
      .invoice-box table tr table td.paddingY { 
          padding-top: 0;
          padding-bottom: 0;
      }
      .invoice-footer table td {
          padding: 10px 0px 10px 0px;
          /* top right bottom left */
      }
    </style></head><body>';

$sql1 = "SELECT DISTINCT A.CAMPUS, C.LEVEL_KEY, C.LEVEL_CODE, C.STUDY_INTAKE, D.STUDY_INTAKE_DESC, A.CUSTOMER_KEY, 
  A.CUSTOMER_NAME, A.REFERENCE_NO, A.CUSTOMER_NO
  FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_DETAILS B, TERM_MASTER C, EXAM_DOCKET D
  WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
  AND B.LIT_KEY = C.LIT_KEY
  AND C.LEVEL_KEY = D.LEVEL_KEY
  AND C.STUDY_INTAKE = D.STUDY_INTAKE
  AND A.CUSTOMER_KEY = $CUSTOMER_KEY
  AND B.LEVEL_KEY = $LEVEL_KEY
  AND C.STUDY_INTAKE = '$STUDY_INTAKE'
  AND D.SUBJECT_CODE NOT IN ('ECE 1230','ECE 1240','SER 1300','THR 1500','ENG 1310','ENG 1320','EDU 1110','INT 1240','SER 1100','EDU 1120', 'IVY PREP', 'INT 1230', 'INT 1114')
  AND D.SUBJECT_KEY IN 
  (SELECT DISTINCT X.SUBJECT_KEY
  FROM CUSTOMER_LEVEL_SUBJECT X
  WHERE X.CUSTOMER_LIT_KEY = B.CUSTOMER_LIT_KEY
  AND X.CUSTOMER_KEY = $CUSTOMER_KEY
  AND X.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Resit', 'Repeat', 'Completed')
  AND X.SUBJECT_CODE NOT IN ('ECE 1230','ECE 1240','SER 1300','THR 1500','ENG 1310','ENG 1320','EDU 1110','INT 1240','SER 1100','EDU 1120', 'IVY PREP', 'INT 1230', 'INT 1114'))
  ORDER BY A.CUSTOMER_NAME";

$result1 = mysqli_query($con,$sql1)or die(mysqli_error($con));
$i=1;

while($arr1=mysqli_fetch_assoc($result1))
{
  $CAMPUS = $arr1["CAMPUS"];
  $LEVEL_KEY = $arr1["LEVEL_KEY"];
  $LEVEL_CODE = $arr1["LEVEL_CODE"];
  $STUDY_INTAKE = $arr1["STUDY_INTAKE"];
  $STUDY_INTAKE_DESC = $arr1["STUDY_INTAKE_DESC"];
  $CUSTOMER_KEY = $arr1["CUSTOMER_KEY"];
  $CUSTOMER_NAME = $arr1["CUSTOMER_NAME"];
  $REFERENCE_NO = $arr1["REFERENCE_NO"];
  $CUSTOMER_NO = $arr1["CUSTOMER_NO"];

  //return into $LEVEL_DESCRIPTION
  $LEVEL_DESCRIPTION = getSingleValue("LEVEL_MASTER","DISTINCT LEVEL_DESCRIPTION","LEVEL_KEY = '".$LEVEL_KEY."'",$con,"");

  $sql2 = "SELECT DISTINCT D.SUBJECT_KEY, D.SUBJECT_CODE, D.SUBJECT_DESCRIPTION, 
    D.EXAM_DATE, DATE_FORMAT(D.EXAM_DATE, '%d %M %Y') EXAM_DATE_DISPLAY, D.EXAM_VENUE, D.EXAM_TIME, D.EXAM_DURATION
    FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_DETAILS B, TERM_MASTER C, EXAM_DOCKET D
    WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
    AND B.LIT_KEY = C.LIT_KEY
    AND C.LEVEL_KEY = D.LEVEL_KEY
    AND C.STUDY_INTAKE = D.STUDY_INTAKE
    AND B.LEVEL_KEY = $LEVEL_KEY
    AND C.STUDY_INTAKE = $STUDY_INTAKE
    AND A.CUSTOMER_KEY = $CUSTOMER_KEY
    AND D.SUBJECT_CODE NOT IN ('ECE 1230','ECE 1240','SER 1300','THR 1500','ENG 1310','EDU 1110','INT 1240','SER 1100','EDU 1120', 'IVY PREP', 'INT 1230', 'INT 1114')
    AND D.SUBJECT_KEY IN 
    (SELECT DISTINCT X.SUBJECT_KEY
    FROM CUSTOMER_LEVEL_SUBJECT X
    WHERE X.CUSTOMER_LIT_KEY = B.CUSTOMER_LIT_KEY
    AND X.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Resit', 'Repeat', 'Completed')
    AND X.SUBJECT_CODE NOT IN ('ECE 1230','ECE 1240','SER 1300','THR 1500','ENG 1310','EDU 1110','INT 1240','SER 1100','EDU 1120', 'IVY PREP', 'INT 1230', 'INT 1114'))
    ORDER BY D.EXAM_DATE, D.SUBJECT_CODE";
  $result2 = mysqli_query($con,$sql2)or die(mysqli_error($con));
  $SuvjectHtml = '';
  while($arr2=mysqli_fetch_assoc($result2))
  {
    $SUBJECT_KEY = $arr2["SUBJECT_KEY"];
    $SUBJECT_CODE = $arr2["SUBJECT_CODE"];
    $SUBJECT_DESCRIPTION = $arr2["SUBJECT_DESCRIPTION"];
    $EXAM_DATE = $arr2["EXAM_DATE"];
    $EXAM_DATE_DISPLAY = $arr2["EXAM_DATE_DISPLAY"];
    $EXAM_VENUE = $arr2["EXAM_VENUE"];
    $EXAM_TIME = $arr2["EXAM_TIME"];
    $EXAM_DURATION = $arr2["EXAM_DURATION"];
    
    if ($EXAM_VENUE != "" && $EXAM_VENUE != " " && $EXAM_VENUE != null)
    {
        $SUBJECT_INFO = $SUBJECT_CODE.' '.$SUBJECT_DESCRIPTION;
        
        $SuvjectHtml .='<tr>
                            <td style="border-bottom:solid 1px #000; border-right:solid 1px #000;font-size:12px;">'.$EXAM_DATE_DISPLAY.'</td>
                            <td style="border-bottom:solid 1px #000; border-right:solid 1px #000;font-size:12px;text-align:center;">'.$EXAM_VENUE.'</td>
                            <td style="border-bottom:solid 1px #000; border-right:solid 1px #000;font-size:12px;">'.$EXAM_TIME.'</td>
                            <td style="border-bottom:solid 1px #000; border-right:solid 1px #000;font-size:12px;text-align:center;">'.$EXAM_DURATION.'</td>
                            <td style="border-bottom:solid 1px #000; border-right:solid 1px #000;font-size:12px;">'.$SUBJECT_INFO.'</td>
                        </tr>';
    }
  }

  if($i >= 2){
    $stylePageBrake = 'page-break-before: always;';
  }else{
    $stylePageBrake = '';
  }
  
  if ($CAMPUS == 'MCKL')
    $LOGO_IMAGE = 'MCKL_Logo1.png';
  else
    $LOGO_IMAGE = 'MCKL_Logo2.png';

  $html .='<div class="invoice-box" style="'.$stylePageBrake.'">
      <div class="invoice-box">
          <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif; font-size:14pt;">
              <tbody>
                  <tr>
                      <td align="left">
                          <img src="Image/'.$LOGO_IMAGE.'" style="width:100%; max-width:220px; margin-right:0px;">
                      </td>
                      <td align="right" style="width:270px;">
                          <table style="border:solid 1px #000;text-align:right; font-weight:bold;" width="100%">
                              <tr><td style="height: 5px;"></td></tr>
                              <tr>
                                  <td style="font-size:18px;">
								     &nbsp;&nbsp; EXAMINATION DOCKET &nbsp;&nbsp;
								  </td>
                              </tr>
                              <tr><td style="height: 5px;"></td></tr>
                          </table>
                      </td>
                  </tr>
              </tbody>
          </table>
          <table cellpadding="0" cellspacing="0" style="font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif; font-size:11pt; line-height:16pt;">
              
              <tr class="information">
                  <td style="font-size:13px;">
                      <strong>'.$LEVEL_DESCRIPTION.'</strong><br>
                      <strong>Final Examination : '.$STUDY_INTAKE_DESC.' Session</strong>
                  </td>
              </tr>
          </table>

          <table width="800" border="1" cellpadding="0" cellspacing="4" style="margin-top:10px;font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif;width:90%;" >
              <tbody>
                  <tr>
                      <td border="1" width="180">Candidate Name :</td> 
                      <td border="1" style="font-size:12px;">'.$CUSTOMER_NAME.'</td> 
                  </tr>
                  <tr>
                      <td border="1">Admission Number :</td>
                      <td border="1" style="font-size:12px;">'.$REFERENCE_NO.'</td>
                  </tr>
                  <tr>
                      <td border="1">Student No :</td>
                      <td border="1" style="font-size:12px;">'.$CUSTOMER_NO.'</td>
                  </tr>
              </tbody>
          </table>
          <div style="margin-top:15px; height:390px;">
		      <br /><br /><br /><br /><br /><br />
              <table style="font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif; font-size:11pt; border-top:solid 1px #000; border-left:solid 1px #000;" border="0" cellspacing="0" cellpadding="4">
                  <thead>
                      <tr>
                          <th style="border-bottom:solid 1px #000; border-right:solid 1px #000;text-align:left;width:130px;">Date</th>
                          <th style="border-bottom:solid 1px #000; border-right:solid 1px #000;text-align:center;width:110px;">Venue</th>
                          <th style="border-bottom:solid 1px #000; border-right:solid 1px #000;text-align:left;width:140px;">Time</th>
                          <th style="border-bottom:solid 1px #000; border-right:solid 1px #000;text-align:center;width:100px;">Duration</th>
                          <th style="border-bottom:solid 1px #000; border-right:solid 1px #000;text-align:left;">Paper</th>
                      </tr>
                  </thead>
                  <tbody>
                      
                      '.$SuvjectHtml.'
                      
                  </tbody>
              </table>
          </div>

          
          <div style="height:20pt;">
              &nbsp;
          </div>

          <table cellpadding="0" cellspacing="0" class="footerTable" style="font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif; font-size:12pt;" border="0">
              <tr>
                  <td class="modeOfPayment paddingY" ><small>By entering these examinations, you agree to be bound by the rules and regulations for the conduct of examinations.</small></td>
              </tr>
              <tr>
                  <td class="modeOfPayment paddingY" ><small>You must read the examination regulations that is printed on the reverse of this document, and sign the candidate'."'".'s declaration.</small></td>
              </tr>
              <tr>
                  <td class="modeOfPayment paddingY" ><small>This exam docket must be printed on a A4-sized paper; double-sided only, and be brought into the exam venue together with your student ID.</small></td>
              </tr>
              <tr>
                  <td class="modeOfPayment paddingY" ><small>There must not be any markings on this exam docket. Keep this examination docket in a safe place until results are published.</small></td>
              </tr>
          </table>
      </div>

      <br />
      <div class="invoice-box">
        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif; font-size:11pt; line-height:9pt;">
            <tr>
                <td colspan="2">
                    <b>Examination Regulations</b>
                </td>
            </tr>
            <tr>
                <td style="width: 12px">
                    &nbsp;&nbsp;&nbsp;1.
                </td>
                <td>
                    You must be present at the examination venue 15 minutes before the start of the paper.
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;2.
                </td>
                <td>
                    You must not take an examination in the name of another candidate.
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;3.
                </td>
                <td>
                    You must not have any markings on your stationery, clothing or on your body.
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;4.
                </td>
                <td>
                    <b>Stationery must be hand-held.  Only mineral water bottles (disposable) are allowed (please remove labels).</b>
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;5.
                </td>
                <td>
                    Food, bags, wallets, purses & communicative electronic devices are not allowed in the examination venue.
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;6.
                </td>
                <td>
                    You are not allowed to bring books or notes into the examination venue, which may give you an unfair advantage.
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;7.
                </td>
                <td>
                    Copying, collusion and any form of cheating will not be tolerated during the examination.
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;8.
                </td>
                <td>
                    <b>Mobile phones, smart watches and communicative devices are not allowed in the examination venue.</b>
                </td>
            </tr>
            <tr>
                <td style="line-height: 1.3;">
                    &nbsp;&nbsp;&nbsp;9.<br />&nbsp;
                </td>
                <td style="line-height: 1.3;">
                    Possession of unauthorized item(s) is a breach of examination rules, even if you do not intend to use the said item(s).  If any of the above <br />is found in your possession, you may be subjected to disciplinary action (academic hearing and/or dismissal) from the programme.
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;10.
                </td>
                <td>
                    Do not remove any exam materials when exiting the examination venue.  Leave all used and unused exam materials on your table.
                </td>
            </tr>
        </table>
        <br /><br />
        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif; font-size:11pt; line-height:9pt;">
            <tr>
                <td colspan="2">
                    <b>Candidates MUST attend all your registered papers & be on time.</b>
                </td>
            </tr>
            <tr>
                <td style="width: 12px">
                    &nbsp;&nbsp;&nbsp;1.
                </td>
                <td>
                    Candidates who arrive 30 minutes after the start time of the examination - will not be allowed into the examination venue.
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;2.
                </td>
                <td>
                    Candidates are not allowed to leave within the first 30 minutes, and the last 30 minutes of the examination.
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;3.
                </td>
                <td>
                    Students who arrive late, if permitted into the exam hall, will not have extra time.
                </td>
            </tr>
            <tr>
                <td>
                    &nbsp;&nbsp;&nbsp;4.
                </td>
                <td>
                    Valid reasons for medical emergencies, train disruptions, or accidents must have documented evidence.
                </td>
            </tr>
        </table>
        <br /><br />
        <table border="1" align="left" cellpadding="0" cellspacing="0" style="width: 85%; margin-left: 10px; font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif; font-size:11pt; line-height:14pt;">
            <tr style="background-color: #dddddd">
                <td colspan="4">
                    <b>Declaration by the candidate:</b>
                    <br /><br />
                    <b>Sign below to indicate you understand, and agree to comply with the exam regulations above.</b>
                    <br />
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td style="width: 8%">
                    &nbsp;
                    <br />
                    <b>Signature:</b>
                    <br />
                    &nbsp;
                </td>
                <td style="width: 42%">
                    &nbsp;
                </td>
                <td style="width: 6%">
                    &nbsp;
                    <br />
                    <b>Date:</b>
                    <br />
                    &nbsp;
                </td>
                <td style="width: 44%">
                    &nbsp;
                </td>
            </tr>
        </table>
      </div>
  </div>';
  $i++;
}

$html .= '</body></html>';

$html = $html;

// $mpdf = new mPDF('utf-8', 'letter-L', 0, 0, 6, 6, 10, 10, 0); // use this customization
// $mpdf->setAutoTopMargin = 'stretch'; // Set pdf top margin to stretch to avoid content overlapping
// $mpdf->setAutoBottomMargin = 'stretch'; // Set pdf bottom margin to stretch to avoid content overlapping
// $mpdf->WriteHTML($stylesheet, 1);
// $mpdf->AddPage('', 'E');
// $mpdf->AddPage();
// $mpdf->SetHTMLFooter();
// $mpdf->WriteHTML($html);
// $mpdf->Output();
$report_name = preg_replace('/[^a-zA-Z0-9_ -]/s', '', $CUSTOMER_NAME);
$report_name = 'Exam_Docket-'.$report_name;

$mpdf = new \Mpdf\Mpdf(['mode' => 'utf-8', 'format' => 'letter-L','0','',0,0,0,0,'margin_header' => 0,'orientation' => 'L', 'autoPageBreak' => true]);
$mpdf->setAutoTopMargin = 'stretch';
$mpdf->setAutoBottomMargin = 'stretch';
$mpdf->AddPage('','E');
$mpdf->AddPage('L','','','','',6,6,10,10,0,0);
$mpdf->WriteHTML($html);
$mpdf->SetProtection(array('print','print-highres'),'','[]mckl@0322741851&mcpg#042175088()');
$mpdf->Output($report_name.".pdf","I");
exit;
?>