<?php
$page = "s_cpassword";
include('session_verify.php');
include('portal_header.php');
?>

<!-- Extra Css Or Special Design -->
<style>
    .vertical-center {
        /* height: 100%; */
        /* text-align: center; */
        padding: 70px 0;
        max-width: 1200px;
    }



    @media (max-width: 768px) {
        .vertical-center {
            /* text-align: center; */
            padding: 70px 0;
            max-width: 400px;
        }
    }
</style>

<?php
include('portal_navbar.php');
?>

<!-- Content Here -->
<main>
    <div class="container vertical-center">
        <h1>Change Password</h1>
        <div class="card">
            <div class="card-body">
                <form id="s_cpassword_form" action="" method="post" onsubmit="return false">
                    <div class="mb-3">
                        <label for="old_pass" class="form-label">Old Password</label>
                        <input type="password" class="form-control" id="old_pass" name="old_pass" minlength="8" required />
                    </div>
                    <div class="mb-3">
                        <label for="new_password" class="form-label">New Password</label>
                        <input type="password" class="form-control" id="new_password" name="new_password" minlength="8" required />
                        <i>Min Required 8 Character</i>
                    </div>
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Confirm New Password</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" minlength="8" required />
                    </div>
                    <br />
                    <button id="s_cpassword_submit" class="btn btn-primary">Submit</button>
                </form>
            </div>
        </div>
    </div>
</main>
<script>
    $('#s_cpassword_submit').click(function(e) {
        // $("#add_parent_form").submit();
        // e.preventDefault();
        var form = $("#s_cpassword_form").serialize();
        var old_pass = $('#old_pass').val();
        var new_password = $('#new_password').val();
        var confirm_password = $('#confirm_password').val();
        if (old_pass == "" || new_password == "" || confirm_password == "" || old_pass.length < 8 || new_password.length < 8 || confirm_password.length < 8) {
            $("#s_cpassword_form").submit();
        } else {
            e.preventDefault();
            $.ajax({
                url: 'script.php?action=s_cpassword&CUSTOMER_KEY=<?php echo $login_userkey ?>&BRANCH=<?php echo $SELECTED_BRANCH ?>',
                type: 'POST',
                data: form,

                success: function(output) {
                    if (output == "old_pass") {
                        alert('Old Password Not Match, Please Try Again.');
                    } else if (output == "not_match") {
                        alert('New Password and Confirm New Password Not Match, Please try Again.');
                    } else if (output == "ok") {
                        alert('Password Successful Changed !');
                        window.location.href = 'main_index.php';
                    } else {
                        alert(output);
                    }
                }
            });
        }
    });
</script>
<?php
include('portal_footer.php');
?>