<?php
$page = "cohort";
include('session_verify.php');
include('portal_header.php');
?>
<title>Student's Cohort Enrolled and Subject Enrolled</title>
<!-- Extra Css Or Special Design -->

<style>
    th {
        background-color: blue;
        /* color: black; */
    }

    .normal-text-bg {
        font-weight: normal;
        font-size: 20px;
    }

    .lg-title {
        font-size: 26px;
    }
</style>

<?php
include('portal_navbar.php');
include('db_config.php');
?>

<!-- Content Here -->
<div class="container">
    <br />
    <div class="container-fluid">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
                <?php
                $cohort_sql1 = mysqli_query($con, "SELECT DISTINCT A.CUSTOMER_KEY, A.CUSTOMER_LIT_KEY, B.LEVEL_KEY, B.INTAKE_KEY, B.LIT_KEY, 
                    B.LEVEL_CODE, C.LEVEL_DESCRIPTION, B.INTAKE_NO, B.TERM_NO, 
                    DATE_FORMAT(B.TERM_START_DATE, '%M %Y') TERM_START_DATE, DATE_FORMAT(B.TERM_END_DATE, '%M %Y') TERM_END_DATE
                    FROM CUSTOMER_LEVEL_DETAILS A, TERM_MASTER B, LEVEL_MASTER C
                    WHERE A.LIT_KEY = B.LIT_KEY
                    AND B.LEVEL_KEY = C.LEVEL_KEY
                    AND A.CUSTOMER_LEVEL_STATUS IN ('Active', 'Transfer In', 'Completed')
                    AND A.CUSTOMER_KEY = $login_userkey
                    ORDER BY B.INTAKE_NO DESC, B.LEVEL_CODE, B.TERM_NO");
                while ($res_cohort1 = mysqli_fetch_assoc($cohort_sql1)) {
                    extract($res_cohort1);
                    
                    $OLD_GRADING_CHECK = 0;
                    
                    if (substr($INTAKE_NO, 4, 2) == '01')
                        $INTAKE_NO_DISPLAY = 'January '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '02')
                        $INTAKE_NO_DISPLAY = 'February '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '03')
                        $INTAKE_NO_DISPLAY = 'March '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '04')
                        $INTAKE_NO_DISPLAY = 'April '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '05')
                        $INTAKE_NO_DISPLAY = 'May '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '06')
                        $INTAKE_NO_DISPLAY = 'June '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '07')
                        $INTAKE_NO_DISPLAY = 'July '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '08')
                        $INTAKE_NO_DISPLAY = 'August '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '09')
                        $INTAKE_NO_DISPLAY = 'September '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '10')
                        $INTAKE_NO_DISPLAY = 'October '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '11')
                        $INTAKE_NO_DISPLAY = 'November '.substr($INTAKE_NO, 0, 4).' Intake';
                    else if (substr($INTAKE_NO, 4, 2) == '12')
                        $INTAKE_NO_DISPLAY = 'December '.substr($INTAKE_NO, 0, 4).' Intake';
                    else
                        $INTAKE_NO_DISPLAY = $INTAKE_NO.' Intake';
                    
                    $DISPLAY = $LEVEL_DESCRIPTION . " (" . $LEVEL_CODE . ")<br>" . $INTAKE_NO_DISPLAY . " - Term " . $TERM_NO . " (" . $TERM_START_DATE . " to " . $TERM_END_DATE . ")";
                    
                    $sql_subject = mysqli_query($con, "SELECT DISTINCT B.SUBJECT_KEY, B.SUBJECT_CODE, B.SUBJECT_DESCRIPTION, A.SUBJECT_CREDITS, 
                    A.CUSTOMER_SUBJECT_STATUS, A.SUBJECT_ORIGINAL_STATUS
                    FROM CUSTOMER_LEVEL_SUBJECT A, SUBJECT_MASTER B
                    WHERE A.SUBJECT_KEY = B.SUBJECT_KEY
                    AND A.CUSTOMER_KEY = $login_userkey
                    AND A.LIT_KEY = $LIT_KEY
                    AND A.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Resit', 'Repeat', 'Exempted', 'Withdrawn')
                    ORDER BY B.SUBJECT_CODE");
                    $table_data = "";
                    if (mysqli_num_rows($sql_subject) > 0) {
                        while ($res_subject = mysqli_fetch_assoc($sql_subject)) {

                            extract($res_subject);
                            if ($CUSTOMER_SUBJECT_STATUS == 'Withdrawn') {
                                $SUBJECT_DESC_REMARKS = ' (W)';
                            } else if ($CUSTOMER_SUBJECT_STATUS == 'Exempted') {
                                $SUBJECT_DESC_REMARKS = ' (EX)';
                            } else {
                                if ($SUBJECT_ORIGINAL_STATUS == 'Resit' || $SUBJECT_ORIGINAL_STATUS == 'Repeat') {
                                    $sql_repeat_time = mysqli_query($con, "SELECT COUNT(*) AS V_CHK
                                    FROM CUSTOMER_LEVEL_SUBJECT
                                    WHERE CUSTOMER_KEY = $login_userkey
                                    AND LEVEL_KEY = $LEVEL_KEY
                                    AND INTAKE_KEY = $INTAKE_KEY
                                    AND TERM_NO <= $TERM_NO
                                    AND SUBJECT_KEY = $SUBJECT_KEY
                                    AND SUBJECT_ORIGINAL_STATUS IN ('Resit', 'Repeat')");
                                    $res_repeat = mysqli_fetch_assoc($sql_repeat_time);
                                    //return into $V_CHK

                                    $SUBJECT_DESC_REMARKS = ' (R' . $res_repeat['V_CHK'] . ')';
                                } else {
                                    $SUBJECT_DESC_REMARKS = '';
                                }
                            }
                            
                            if (substr_count($SUBJECT_DESCRIPTION,"*") > 0)
                            {
                                //$SUBJECT_DESCRIPTION = $SUBJECT_DESCRIPTION.'<b><sup>(1)</sup></b>';
                                $OLD_GRADING_CHECK = $OLD_GRADING_CHECK + 1;
                            }
                            
                            //First Column = $SUBJECT_CODE
                            //Second Column = $SUBJECT_DESCRIPTION.$SUBJECT_DESC_REMARKS
                            //Third Column = $SUBJECT_CREDITS
                            $table_data .= "<tr>
                        <td>" . $SUBJECT_CODE . "</td>
                        <td>" . $SUBJECT_DESCRIPTION . "</td>
                        <td>" . $SUBJECT_CREDITS . $SUBJECT_DESC_REMARKS . "</td>
                    </tr>";
                        }
                    } else {
                    }
                ?>
                    <div class="card">

                        <div class="card-body">
                            <div>
                                <h3><?php echo $DISPLAY; ?></h3>
                            </div>

                            <table class="table table-bordered">
                                <thead>
                                    <tr class="table-primary">
                                        <th style="width: 20%">Code</th>
                                        <th style="width: 65%">Description</th>
                                        <th style="width: 15%">Credit Hours</th>
                                    </tr>

                                </thead>
                                <tbody>
                                    <?php
                                    echo $table_data;
                                    ?>

                                </tbody>
                            </table>
                            <?php
                            if ($OLD_GRADING_CHECK > 0)
                            {
                            ?>
                            <i>* - This subject follows the old Grading Scheme.</i>
                            <br>
                            <?php
                            }
                            ?>
                            <i>**Disclaimer: The information shown is correct at the time of printing/viewing (<?php echo date('d F Y h:i:s a', time()) ?>)**</i>
                        </div>
                    </div>
                    <br />
                <?php
                }
                ?>


            </div>
            <!--/.col (left) -->
        </div>
        <!-- /.row -->

    </div>
</div>

<?php
include('portal_footer.php');
?>