<?php
$page = "bursary";
include('session_verify.php');
include('portal_header.php');
?>
<title>Student's Outstanding Invoice and Amount</title>
<!-- Extra Css Or Special Design -->

<style>
    th {
        background-color: blue;
        /* color: black; */
    }

    .normal-text-bg {
        font-weight: normal;
        font-size: 20px;
    }

    .lg-title {
        font-size: 26px;
    }
</style>

<?php
include('portal_navbar.php');
include('db_config.php');
?>

<!-- Content Here -->
<div class="container">
    <br />
    <div class="container-fluid">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
                <?php
                $sql_outstanding_amount = mysqli_query($con, "SELECT SUM(ALL NET_PAYABLE_AMOUNT) AS NET_PAYABLE_AMOUNT
                                            FROM CUSTOMER_FEE_MASTER 
                                            WHERE CUSTOMER_KEY = $login_userkey");
                $res_sql_outstanding_amount = mysqli_fetch_assoc($sql_outstanding_amount);
                $data = "";
                //return as $NET_PAYABLE_AMOUNT
                if ($res_sql_outstanding_amount['NET_PAYABLE_AMOUNT'] == 0) {
                    $OUTSTANDING_DISPLAY = "No Outstanding.";
                } else {
                    $OUTSTANDING_DISPLAY = "RM" . number_format($res_sql_outstanding_amount['NET_PAYABLE_AMOUNT'], 2);

                    $sql_outstanding_invoice = mysqli_query($con, "SELECT DISTINCT LIT_KEY, LEVEL_CODE, INTAKE_NO, TERM_NO, INVOICE_KEY, 
                    INVOICE_NO, PAYMENT_DATE, SUM(ALL NET_PAYABLE_AMOUNT) AS TOTAL_INVOICE_OUTSTANDING
                    FROM CUSTOMER_FEE_MASTER
                    WHERE CUSTOMER_KEY = $login_userkey
                    AND NET_PAYABLE_AMOUNT > 0
                    GROUP BY LIT_KEY, LEVEL_CODE, INTAKE_NO, TERM_NO, INVOICE_KEY, INVOICE_NO, PAYMENT_DATE");

                    while ($res_outstanding_invoice = mysqli_fetch_assoc($sql_outstanding_invoice)) {
                        $data .= "<tr>";
                        $data .= "<td>" . $res_outstanding_invoice['LEVEL_CODE'] . "</td>";
                        $data .= "<td>" . $res_outstanding_invoice['INTAKE_NO'] . "</td>";
                        $data .= "<td>" . $res_outstanding_invoice['TERM_NO'] . "</td>";
                        $data .= "<td>" . $res_outstanding_invoice['INVOICE_NO'] . "</td>";
                        $data .= "<td>" . $res_outstanding_invoice['PAYMENT_DATE'] . "</td>";
                        $data .= "<td>" . $res_outstanding_invoice['TOTAL_INVOICE_OUTSTANDING'] . "</td>";
                        $data .= "</tr>";

                        //$LEVEL_CODE
                        //$INTAKE_NO
                        //$TERM_NO
                        //$INVOICE_NO
                        //$PAYMENT_DATE
                        //$TOTAL_INVOICE_OUTSTANDING
                    }
                    //Display below wording in italic and bold
                    //**Disclaimer: The information shown is correct at the time of printing/viewing (31 December 2022 23:59:59)**
                }

                $sql_cohort_intake = mysqli_query($con, "SELECT DISTINCT A.CUSTOMER_KEY, B.LEVEL_KEY, B.INTAKE_KEY, B.LEVEL_CODE, C.LEVEL_DESCRIPTION, B.INTAKE_NO
                FROM CUSTOMER_LEVEL_DETAILS A, TERM_MASTER B, LEVEL_MASTER C
                WHERE A.LIT_KEY = B.LIT_KEY
                AND B.LEVEL_KEY = C.LEVEL_KEY
                AND A.CUSTOMER_KEY = $login_userkey
                ORDER BY B.INTAKE_NO DESC, B.LEVEL_CODE");
                if (mysqli_num_rows($sql_cohort_intake) > 0) {
                    $data2 = "";
                    $data_table2 = "";
                    $count = 0;
                    while ($res_sql_cohort = mysqli_fetch_assoc($sql_cohort_intake)) {


                        $data_table1 = "";
                        extract($res_sql_cohort);
                        if (substr($INTAKE_NO, 4, 2) == '01')
                            $INTAKE_NO_DISPLAY = 'January ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '02')
                            $INTAKE_NO_DISPLAY = 'February ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '03')
                            $INTAKE_NO_DISPLAY = 'March ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '04')
                            $INTAKE_NO_DISPLAY = 'April ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '05')
                            $INTAKE_NO_DISPLAY = 'May ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '06')
                            $INTAKE_NO_DISPLAY = 'June ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '07')
                            $INTAKE_NO_DISPLAY = 'July ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '08')
                            $INTAKE_NO_DISPLAY = 'August ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '09')
                            $INTAKE_NO_DISPLAY = 'September ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '10')
                            $INTAKE_NO_DISPLAY = 'October ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '11')
                            $INTAKE_NO_DISPLAY = 'November ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '12')
                            $INTAKE_NO_DISPLAY = 'December ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else
                            $INTAKE_NO_DISPLAY = $INTAKE_NO . ' Intake';
                        if ($count == 0) {
                            $DISPLAY = "<u>Invoice</u><br/>" . $LEVEL_DESCRIPTION . " (" . $LEVEL_CODE . ") - " . $INTAKE_NO_DISPLAY;
                        } else {
                            $DISPLAY = $LEVEL_DESCRIPTION . " (" . $LEVEL_CODE . ") - " . $INTAKE_NO_DISPLAY;
                        }

                        $sql_cohort_term = mysqli_query($con, "SELECT DISTINCT A.CUSTOMER_LIT_KEY, B.LIT_KEY, B.TERM_NO, 
                        DATE_FORMAT(B.TERM_START_DATE, '%M %Y') TERM_START_DATE, DATE_FORMAT(B.TERM_END_DATE, '%M %Y') TERM_END_DATE
                        FROM CUSTOMER_LEVEL_DETAILS A, TERM_MASTER B, LEVEL_MASTER C
                        WHERE A.LIT_KEY = B.LIT_KEY
                        AND B.LEVEL_KEY = C.LEVEL_KEY
                        AND A.CUSTOMER_KEY = $login_userkey
                        AND B.LEVEL_KEY = '" . $res_sql_cohort['LEVEL_KEY'] . "'
                        AND B.INTAKE_KEY = '" . $res_sql_cohort['INTAKE_KEY'] . "'
                        ORDER BY LIT_KEY");
                        while ($res_cohort_term = mysqli_fetch_assoc($sql_cohort_term)) {
                            $sql_invoice = mysqli_query($con, "SELECT DISTINCT INVOICE_KEY, INVOICE_NO
                            FROM CUSTOMER_FEE_MASTER
                            WHERE CUSTOMER_KEY = $login_userkey
                            AND LIT_KEY = " . $res_cohort_term['LIT_KEY'] . "
                            ORDER BY INVOICE_NO");
                            if (mysqli_num_rows($sql_invoice) > 0) {
                                $count_invoice = 0;
                                while ($res_sql_invoice = mysqli_fetch_assoc($sql_invoice)) {
                                    $INVOICE_NO = $res_sql_invoice['INVOICE_NO'];
                                    if ($count_invoice == 0) {
                                        $button = "";
                                        $button = "<button type='button' onclick='invoice_form(" . $res_cohort_term['LIT_KEY'] . "," . $res_sql_invoice['INVOICE_KEY'] . ")' class='btn btn-primary btn-sm' style='min-width:100px;'>Print Invoice</button>";
                                        //Print Button (WITH $LIT_KEY and $INVOICE_KEY)
                                        //student_invoice_printing.php?LIT_KEY=&INVOICE_KEY= (decode it)
                                        $data_table1 .= "<tr>";
                                        $data_table1 .= "<td>Term " . $res_cohort_term['TERM_NO'] . " ( " . $res_cohort_term['TERM_START_DATE'] . " to " . $res_cohort_term['TERM_END_DATE'] . " )</td>";
                                        $data_table1 .= "<td>" . $INVOICE_NO . "</td>";
                                        $data_table1 .= "<td>" . $button . "</td>";
                                        $data_table1 .= "</tr>";
                                        $count_invoice++;
                                    } else if ($count_invoice > 0) {
                                        $button = "";
                                        $button = "<button type='button' onclick='invoice_form(" . $res_cohort_term['LIT_KEY'] . "," . $res_sql_invoice['INVOICE_KEY'] . ")' class='btn btn-primary btn-sm' style='min-width:100px;'>Print Invoice</button>";
                                        //Print Button (WITH $LIT_KEY and $INVOICE_KEY)
                                        //student_invoice_printing.php?LIT_KEY=&INVOICE_KEY= (decode it)
                                        $data_table1 .= "<tr>";
                                        $data_table1 .= "<td style='border-top:1px solid Transparent;'></td>";
                                        $data_table1 .= "<td>" . $INVOICE_NO . "</td>";
                                        $data_table1 .= "<td>" . $button . "</td>";
                                        $data_table1 .= "</tr>";
                                        $count_invoice++;
                                    }
                                }
                            }
                        }
                        $data2 .= '<div class="card-body">
                    <div>
                        <h3>' . $DISPLAY . '</h3>
                    </div>
                    <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr class="table-primary">
                                <th>Invoice No</th>
                                <th style="width: 20%">Term</th>
                                <th style="width: 20%">Action</th>
                            </tr>

                        </thead>
                        <tbody>
                           ' . $data_table1 . '
                        </tbody>
                    </table>
                    </div>
                    
                    <i>**Disclaimer: The information shown is correct at the time of printing/viewing (' . date('d F Y h:i:s a', time()) . ')**</i> </div>';
                        $count++;
                    }
                }
                $sql_receipt = mysqli_query($con, "SELECT DISTINCT A.RECEIPT_KEY, A.RECEIPT_NO, A.MODE_OF_PAYMENT, A.COLLECTION_AMOUNT,
                                                    DATE_FORMAT(A.COLLECTION_DATE, '%Y-%m-%d') COLLECTION_DATE
                                                    FROM CUSTOMER_COLLECTION_MASTER A, CUSTOMER_COLLECTION_DETAIL B
                                                    WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
                                                    AND A.RECEIPT_KEY = B.RECEIPT_KEY
                                                    AND A.RECEIPT_STATUS = 'Active'
                                                    AND A.TRANSACTION_TYPE = 'Original Receipt'
                                                    AND A.CUSTOMER_KEY = $login_userkey
                                                    ORDER BY A.COLLECTION_DATE DESC");
                if (mysqli_num_rows($sql_receipt) > 0) {
                    while ($res_sql_receipt = mysqli_fetch_assoc($sql_receipt)) {
                        $data_table2 .= "<tr>";
                        $data_table2 .= "<td>" . $res_sql_receipt['RECEIPT_NO'] . "</td>";
                        $data_table2 .= "<td>" . $res_sql_receipt['MODE_OF_PAYMENT'] . "</td>";
                        $data_table2 .= "<td>" . $res_sql_receipt['COLLECTION_DATE'] . "</td>";
                        $data_table2 .= "<td>" . number_format($res_sql_receipt['COLLECTION_AMOUNT'], 2) . "</td>";
                        //$RECEIPT_NO
                        //$MODE_OF_PAYMENT
                        //$COLLECTION_DATE

                        $seven_working_day = strtotime($res_sql_receipt['COLLECTION_DATE']);
                        $seven_working_day = strtotime("+7 weekdays", $seven_working_day);
                        $seven_working_day = date('Ymd', $seven_working_day);

                        $today_date = date("Ymd");
                        $button2 = "";
                        if ($seven_working_day < $today_date) {

                            $button2 = "<button type='button' onclick='receipt_form(" . $res_sql_receipt['RECEIPT_KEY'] . ")' class='btn btn-primary btn-sm' style='min-width:100px;'>Print Receipt</button>";
                            //Print button (WITH $RECEIPT_KEY AND $login_userkey)
                            //student_receipt_printing.php?RECEIPT_KEY= (decode it)
                        } else {
                            $button2 = "<p>Pending Processing</p>";
                            //Display "Pending Processing", no Print button
                        }
                        $data_table2 .= "<td>" . $button2 . "</td>";
                        $data_table2 .= "</tr>";
                    }
                } else {
                    $data_table2 = "";
                    $data_table2 .= "<tr>";
                    $data_table2 .= "<td colspan='4'><center>No Data Available</center></td></tr>";
                }
                $data3 = "";
                $data3 .= '<div class="card-body">
                    <div>
                        <h3><u>Receipt</u></h3>
                    </div>
                    <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr class="table-primary">
                                <th>Receipt No</th>
                                <th>Mode Of Payment</th>
                                <th>Collection Date</th>
                                <th style="width: 20%">Collection Amount</th>
                                <th style="width: 20%">Action</th>
                            </tr>

                        </thead>
                        <tbody>
                           ' . $data_table2 . '
                        </tbody>
                    </table>
                    </div>
                    <i><p>*Payment Accepted for Processing: Kindly allow between 5 - 7 working days for update.</p></i>
                    <i><p>**Disclaimer: The information shown is correct at the time of printing/viewing (' . date('d F Y h:i:s a', time()) . ')**</p></i> </div>';
                ?>
                <!-- <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr class="table-primary">
                                <th style="width: 30%">Receipt No</th>
                                <th style="width: 25%">Mode Of Payment</th>
                                <th style="width: 25%">Collection Date</th>
                                <th style="width: 20%">Action</th>
                            </tr>

                        </thead>
                        <tbody>
                            ' . $data_table2 . '
                        </tbody>
                    </table>
                </div> -->
                <div class="card">

                    <div class="card-body">

                        <?php
                        if ($OUTSTANDING_DISPLAY == "No Outstanding.") {
                        ?>
                            <div>
                                <h3><u>Outstanding Invoice and Amount</u><br /><?php echo $OUTSTANDING_DISPLAY ?></h3>
                            </div>
                        <?php
                        } else {
                        ?>
                            <div>
                                <h3><u>Outstanding Invoice and Amount</u><br /><?php echo "Outstanding Amount: " . $OUTSTANDING_DISPLAY ?></h3>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr class="table-primary">
                                            <th style="width: 15%">Level Code</th>
                                            <th style="width: 15%">Intake No</th>
                                            <th style="width: 10%">Item No</th>
                                            <th style="width: 20%">Invoice No</th>
                                            <th style="width: 20%">Payment Date</th>
                                            <th style="width: 20%">Total Invoice Outstanding</th>
                                        </tr>

                                    </thead>
                                    <tbody>
                                        <?php
                                        echo $data;
                                        ?>

                                    </tbody>
                                </table>

                            </div>
                        <?php  } ?>
                        <i>**Disclaimer: The information shown is correct at the time of printing/viewing (<?php echo date('d F Y h:i:s a', time()) ?>)**</i>
                    </div>
                </div>
                <br />
                <div class="card">
                    <?php echo isset($data2) ? $data2 : ""; ?>
                </div>
                <br />
                <div class="card">
                    <?php echo isset($data3) ? $data3 : ""; ?>
                </div>
                <br />
            </div>
            <!--/.col (left) -->
        </div>
        <!-- /.row -->

    </div>
</div>
<form id="invoice_form" method="post" action="student_invoice_printing.php" target="_blank">
    <input type="hidden" id="INVOICE_KEY" name="INVOICE_KEY" />
    <input type="hidden" id="LIT_KEY" name="LIT_KEY" />
</form>
<form id="receipt_form" method="post" action="student_receipt_printing.php" target="_blank">
    <input type="hidden" id="RECEIPT_KEY" name="RECEIPT_KEY" />
</form>
<script>
    function invoice_form(LIT_KEY, INVOICE_KEY) {
        document.getElementById("LIT_KEY").value = LIT_KEY;
        document.getElementById("INVOICE_KEY").value = INVOICE_KEY;
        document.getElementById("invoice_form").submit();
    }

    function receipt_form(RECEIPT_KEY) {
        document.getElementById("RECEIPT_KEY").value = RECEIPT_KEY;
        document.getElementById("receipt_form").submit();
    }
</script>
<?php
include('portal_footer.php');
?>