<?php
$page = "bursary";
include('session_verify.php');
include('portal_header.php');
?>
<title>Student's Fee</title>
<!-- Extra Css Or Special Design -->

<style>
    th {
        background-color: blue;
        /* color: black; */
    }

    .normal-text-bg {
        font-weight: normal;
        font-size: 20px;
    }

    .lg-title {
        font-size: 26px;
    }
</style>

<?php
include('portal_navbar.php');
include('db_config.php');
?>

<!-- Content Here -->
<div class="container">
    <br />
    <div class="container-fluid">
        <div class="row">
            <!-- left column -->
            <div class="col-md-12">
                <!-- general form elements -->
                <?php
                $sql_outstanding_amount = mysqli_query($con, "SELECT SUM(ALL A.NET_PAYABLE_AMOUNT) AS NET_PAYABLE_AMOUNT
                                                              FROM CUSTOMER_FEE_MASTER A, BURSARY_INVOICE_RELEASE B
                                                              WHERE A.LIT_KEY = B.LIT_KEY
                                                              AND A.CUSTOMER_KEY = $login_userkey
                                                              AND DATE_FORMAT(B.PORTAL_RELEASE_DATE, '%Y%m%d') <= DATE_FORMAT(now(), '%Y%m%d')");
                $res_sql_outstanding_amount = mysqli_fetch_assoc($sql_outstanding_amount);
                $data = "";
                //return as $NET_PAYABLE_AMOUNT
                if ($res_sql_outstanding_amount['NET_PAYABLE_AMOUNT'] == 0) {
                    $OUTSTANDING_DISPLAY = "RM0.00";
                } else {
                    $OUTSTANDING_DISPLAY = "RM" . number_format($res_sql_outstanding_amount['NET_PAYABLE_AMOUNT'], 2);
                }
                
                $sql_overpayment_amount = mysqli_query($con, "SELECT DISTINCT OVERPAYMENT
                                                              FROM CUSTOMER_INFO
                                                              WHERE CUSTOMER_KEY = $login_userkey");
                $res_sql_overpayment_amount = mysqli_fetch_assoc($sql_overpayment_amount);
                $data = "";
                //return as $OVERPAYMENT
                if ($res_sql_overpayment_amount['OVERPAYMENT'] == 0 || $res_sql_overpayment_amount['OVERPAYMENT'] == "" || $res_sql_overpayment_amount['OVERPAYMENT'] == " ") {
                    $OVERPAYMENT_DISPLAY = "RM0.00";
                } else {
                    $OVERPAYMENT_DISPLAY = "RM" . number_format($res_sql_overpayment_amount['OVERPAYMENT'], 2);
                }
                
                $sql_voucher_debit = mysqli_query($con, "SELECT SUM(DEBIT_AMOUNT) AS TOTAL_VOUCHER_DEBIT
                                                         FROM CUSTOMER_VOUCHER
                                                         WHERE CUSTOMER_KEY = $login_userkey
                                                         AND VOUCHER_STATUS = 'Active'");
                $res_sql_voucher_debit = mysqli_fetch_assoc($sql_voucher_debit);
                //return as $TOTAL_VOUCHER_DEBIT
                
                if ($res_sql_voucher_debit['TOTAL_VOUCHER_DEBIT'] == "" || $res_sql_voucher_debit['TOTAL_VOUCHER_DEBIT'] == " " || $res_sql_voucher_debit['TOTAL_VOUCHER_DEBIT'] == NULL)
                {
                    $TOTAL_VOUCHER_DEBIT = 0;
                }
                else
                {
                    $TOTAL_VOUCHER_DEBIT = $res_sql_voucher_debit['TOTAL_VOUCHER_DEBIT'];
                }
                
                $sql_voucher_credit = mysqli_query($con, "SELECT SUM(CREDIT_AMOUNT) AS TOTAL_VOUCHER_CREDIT
                                                          FROM CUSTOMER_VOUCHER
                                                          WHERE CUSTOMER_KEY = $login_userkey
                                                          AND VOUCHER_STATUS = 'Active'");
                $res_sql_voucher_credit = mysqli_fetch_assoc($sql_voucher_credit);
                //return as $TOTAL_VOUCHER_CREDIT
                
                if ($res_sql_voucher_credit['TOTAL_VOUCHER_CREDIT'] == "" || $res_sql_voucher_credit['TOTAL_VOUCHER_CREDIT'] == " " || $res_sql_voucher_credit['TOTAL_VOUCHER_CREDIT'] == NULL)
                {
                    $TOTAL_VOUCHER_CREDIT = 0;
                }
                else
                {
                    $TOTAL_VOUCHER_CREDIT = $res_sql_voucher_credit['TOTAL_VOUCHER_CREDIT'];
                }
                
                $TOTAL_VOUCHER_AMOUNT = $TOTAL_VOUCHER_DEBIT - $TOTAL_VOUCHER_CREDIT;
                

                if ($TOTAL_VOUCHER_AMOUNT == 0 || $TOTAL_VOUCHER_AMOUNT == "" || $TOTAL_VOUCHER_AMOUNT == " ") {
                    $TOTAL_VOUCHER_AMOUNT_DISPLAY = "RM0.00";
                } else {
                    $TOTAL_VOUCHER_AMOUNT_DISPLAY = "RM" . number_format($TOTAL_VOUCHER_AMOUNT, 2);
                }
                
                
                $SUMMARY_GRAND_TOTAL = 0;
                $sql_cohort_intake = mysqli_query($con, "SELECT DISTINCT A.CUSTOMER_KEY, B.LEVEL_KEY, B.INTAKE_KEY, B.LEVEL_CODE, C.LEVEL_DESCRIPTION, B.INTAKE_NO
                                                         FROM CUSTOMER_LEVEL_DETAILS A, TERM_MASTER B, LEVEL_MASTER C
                                                         WHERE A.LIT_KEY = B.LIT_KEY
                                                         AND B.LEVEL_KEY = C.LEVEL_KEY
                                                         AND A.CUSTOMER_KEY = $login_userkey
                                                         AND A.LIT_KEY IN 
                                                         (SELECT DISTINCT LIT_KEY
                                                          FROM BURSARY_INVOICE_RELEASE
                                                          WHERE DATE_FORMAT(PORTAL_RELEASE_DATE, '%Y%m%d') <= DATE_FORMAT(now(), '%Y%m%d'))
                                                         ORDER BY B.INTAKE_NO DESC, B.LEVEL_CODE");
                if (mysqli_num_rows($sql_cohort_intake) > 0) 
                {
                    $data2 = "";
                    $data_table2 = "";
                    $count = 0;
                    $summary_table = "";
                    
                    while ($res_sql_cohort = mysqli_fetch_assoc($sql_cohort_intake)) 
                    {
                        $data_table1 = "";
                        extract($res_sql_cohort);
                        if (substr($INTAKE_NO, 4, 2) == '01')
                            $INTAKE_NO_DISPLAY = 'January ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '02')
                            $INTAKE_NO_DISPLAY = 'February ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '03')
                            $INTAKE_NO_DISPLAY = 'March ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '04')
                            $INTAKE_NO_DISPLAY = 'April ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '05')
                            $INTAKE_NO_DISPLAY = 'May ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '06')
                            $INTAKE_NO_DISPLAY = 'June ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '07')
                            $INTAKE_NO_DISPLAY = 'July ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '08')
                            $INTAKE_NO_DISPLAY = 'August ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '09')
                            $INTAKE_NO_DISPLAY = 'September ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '10')
                            $INTAKE_NO_DISPLAY = 'October ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '11')
                            $INTAKE_NO_DISPLAY = 'November ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else if (substr($INTAKE_NO, 4, 2) == '12')
                            $INTAKE_NO_DISPLAY = 'December ' . substr($INTAKE_NO, 0, 4) . ' Intake';
                        else
                            $INTAKE_NO_DISPLAY = $INTAKE_NO . ' Intake';
                        
                        if ($count == 0) {
                            $DISPLAY = "<u>Fee Details</u><br/>" . $LEVEL_DESCRIPTION . " (" . $LEVEL_CODE . ") - " . $INTAKE_NO_DISPLAY;
                        } else {
                            $DISPLAY = $LEVEL_DESCRIPTION . " (" . $LEVEL_CODE . ") - " . $INTAKE_NO_DISPLAY;
                        }
                        
                        
                        $GRAND_TOTAL = 0;

                        $sql_cohort_term = mysqli_query($con, "SELECT DISTINCT A.CUSTOMER_LIT_KEY, B.LIT_KEY, B.TERM_NO, 
                                                               DATE_FORMAT(B.TERM_START_DATE, '%M') TERM_START_MONTH, 
                                                               DATE_FORMAT(B.TERM_START_DATE, '%y') TERM_START_YEAR, 
                                                               DATE_FORMAT(B.TERM_END_DATE, '%M') TERM_END_MONTH, 
                                                               DATE_FORMAT(B.TERM_END_DATE, '%y') TERM_END_YEAR
                                                               FROM CUSTOMER_LEVEL_DETAILS A, TERM_MASTER B, LEVEL_MASTER C
                                                               WHERE A.LIT_KEY = B.LIT_KEY
                                                               AND B.LEVEL_KEY = C.LEVEL_KEY
                                                               AND A.CUSTOMER_KEY = $login_userkey
                                                               AND B.LEVEL_KEY = '" . $res_sql_cohort['LEVEL_KEY'] . "'
                                                               AND B.INTAKE_KEY = '" . $res_sql_cohort['INTAKE_KEY'] . "'
                                                               AND A.LIT_KEY IN 
                                                               (SELECT DISTINCT LIT_KEY
                                                                FROM BURSARY_INVOICE_RELEASE
                                                                WHERE DATE_FORMAT(PORTAL_RELEASE_DATE, '%Y%m%d') <= DATE_FORMAT(now(), '%Y%m%d'))
                                                               ORDER BY B.LIT_KEY DESC");
                        while ($res_cohort_term = mysqli_fetch_assoc($sql_cohort_term)) 
                        {
                            //Invoice
                            $sql_invoice = mysqli_query($con, "SELECT DISTINCT INVOICE_KEY, INVOICE_NO, SUM(ALL ORIGINAL_AMOUNT) AS ORIGINAL_AMOUNT
                                                               FROM CUSTOMER_FEE_MASTER
                                                               WHERE CUSTOMER_KEY = $login_userkey
                                                               AND LIT_KEY = " . $res_cohort_term['LIT_KEY'] . "
                                                               GROUP BY INVOICE_KEY, INVOICE_NO
                                                               ORDER BY INVOICE_NO");
                            if (mysqli_num_rows($sql_invoice) > 0) 
                            {
                                $count_invoice = 0;
                                while ($res_sql_invoice = mysqli_fetch_assoc($sql_invoice)) 
                                {
                                    $INVOICE_KEY = $res_sql_invoice['INVOICE_KEY'];
                                    $INVOICE_NO = $res_sql_invoice['INVOICE_NO'];
                                    $ORIGINAL_AMOUNT = $res_sql_invoice['ORIGINAL_AMOUNT'];
                                    
                                    if ($count_invoice == 0) 
                                    {
                                        $data_table1 .= "<tr>";
                                        $data_table1 .= "<td>" . $res_cohort_term['TERM_NO'] . ' ( ' . substr($res_cohort_term['TERM_START_MONTH'], 0, 3) . $res_cohort_term['TERM_START_YEAR'] . ' to ' . substr($res_cohort_term['TERM_END_MONTH'], 0, 3) . $res_cohort_term['TERM_END_YEAR'] . ' ) ' . "</td>";
                                        $data_table1 .= "<td>Invoice</td>";
                                        $data_table1 .= "<td><a href='javascript:void(0);' onclick='invoice_form(" . $res_cohort_term['LIT_KEY'] . "," . $res_sql_invoice['INVOICE_KEY'] . ")'>" . $INVOICE_NO . "</a></td>";
                                        $data_table1 .= "<td>" . number_format($ORIGINAL_AMOUNT, 2) . "</td>";
                                        $data_table1 .= "</tr>";
                                        $count_invoice++;
                                    }
                                    else if ($count_invoice > 0) 
                                    {
                                        $data_table1 .= "<tr>";
                                        $data_table1 .= "<td style='border-top:1px solid Transparent;'></td>";
                                        $data_table1 .= "<td>Invoice</td>";
                                        $data_table1 .= "<td><a href='javascript:void(0);' onclick='invoice_form(" . $res_cohort_term['LIT_KEY'] . "," . $res_sql_invoice['INVOICE_KEY'] . ")'>" . $INVOICE_NO . "</a></td>";
                                        $data_table1 .= "<td>" . number_format($ORIGINAL_AMOUNT, 2) . "</td>";
                                        $data_table1 .= "</tr>";
                                        $count_invoice++;
                                    }
                                    
                                    $GRAND_TOTAL = $GRAND_TOTAL + $ORIGINAL_AMOUNT;
                                    
                                    //CN and DN
                                    $sql_adjusted = mysqli_query($con, "SELECT DISTINCT B.REFERENCE_NO, B.ADJUSTED_AMOUNT, B.ADJUSTED_TYPE
                                                                        FROM CUSTOMER_FEE_MASTER A, CUSTOMER_FEE_ADJUST B
                                                                        WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
                                                                        AND A.INVOICE_FEE_KEY = B.INVOICE_FEE_KEY
                                                                        AND A.CUSTOMER_KEY = $login_userkey
                                                                        AND A.INVOICE_KEY = $INVOICE_KEY
                                                                        AND B.ADJUSTED_AMOUNT <> 0
                                                                        ORDER BY B.REFERENCE_NO");
                                    if (mysqli_num_rows($sql_adjusted) > 0) 
                                    {
                                        while ($res_sql_adjusted = mysqli_fetch_assoc($sql_adjusted)) 
                                        {
                                            $REFERENCE_NO = $res_sql_adjusted['REFERENCE_NO'];
                                            $ADJUSTED_AMOUNT = $res_sql_adjusted['ADJUSTED_AMOUNT'];
                                            $ADJUSTED_TYPE = $res_sql_adjusted['ADJUSTED_TYPE'];
                                            
                                            if ($ADJUSTED_AMOUNT > 0)
                                            {
                                                $ADJUSTED_AMOUNT_DISPLAY = number_format($ADJUSTED_AMOUNT, 2);
                                            }
                                            else
                                            {
                                                $ADJUSTED_AMOUNT_DISPLAY = $ADJUSTED_AMOUNT * -1;
                                                $ADJUSTED_AMOUNT_DISPLAY = '(' . number_format($ADJUSTED_AMOUNT_DISPLAY, 2) . ')';
                                            }
                                            
                                            $data_table1 .= "<tr>";
                                            $data_table1 .= "<td style='border-top:1px solid Transparent;'></td>";
                                            $data_table1 .= "<td>Adjustment</td>";
                                            
                                            if ($ADJUSTED_TYPE == 'Debit Note')
                                            {
                                                $data_table1 .= "<td><a href='javascript:void(0);' onclick=" . '"' . "debitnote_form('" . $REFERENCE_NO . "')" . '"'. ">" . $REFERENCE_NO . "</a></td>";
                                            }
                                            else
                                            {
                                                $data_table1 .= "<td><a href='javascript:void(0);' onclick=" . '"' . "creditnote_form('" . $REFERENCE_NO . "')" . '"'. ">" . $REFERENCE_NO . "</a></td>";
                                            }
                                            
                                            $data_table1 .= "<td>" . $ADJUSTED_AMOUNT_DISPLAY . "</td>";
                                            $data_table1 .= "</tr>";
                                            $count_invoice++;
                                            
                                            $GRAND_TOTAL = $GRAND_TOTAL + $ADJUSTED_AMOUNT;
                                        }
                                    }
                                }
                            }
                            
                            //Receipt
                            $sql_receipt = mysqli_query($con, "SELECT DISTINCT A.RECEIPT_KEY, A.RECEIPT_NO, DATE_FORMAT(A.COLLECTION_DATE, '%Y-%m-%d') COLLECTION_DATE, 
                                                               A.OVERPAYMENT, B.LIT_KEY, SUM(ALL B.COLLECTED_AMOUNT) AS TOTAL_COLLECTED
                                                               FROM CUSTOMER_COLLECTION_MASTER A, CUSTOMER_COLLECTION_DETAIL B
                                                               WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
                                                               AND A.RECEIPT_KEY = B.RECEIPT_KEY
                                                               AND A.RECEIPT_STATUS = 'Active'
                                                               AND A.TRANSACTION_TYPE = 'Original Receipt'
                                                               AND A.CUSTOMER_KEY = $login_userkey
                                                               AND B.LIT_KEY = " . $res_cohort_term['LIT_KEY'] . "
                                                               GROUP BY A.RECEIPT_KEY, A.RECEIPT_NO, COLLECTION_DATE
                                                               ORDER BY A.COLLECTION_DATE");
                            if (mysqli_num_rows($sql_receipt) > 0) 
                            {
                                while ($res_sql_receipt = mysqli_fetch_assoc($sql_receipt)) 
                                {
                                    $RECEIPT_KEY = $res_sql_receipt['RECEIPT_KEY'];
                                    $RECEIPT_NO = $res_sql_receipt['RECEIPT_NO'];
                                    $COLLECTION_DATE = $res_sql_receipt['COLLECTION_DATE'];
                                    $OVERPAYMENT = $res_sql_receipt['OVERPAYMENT'];
                                    $RECEIPT_LIT_KEY = $res_sql_receipt['LIT_KEY'];
                                    $TOTAL_COLLECTED = $res_sql_receipt['TOTAL_COLLECTED'];
                                    
                                    
                                    $seven_working_day = strtotime($COLLECTION_DATE);
                                    $seven_working_day = strtotime("+7 weekdays", $seven_working_day);
                                    $seven_working_day = date('Ymd', $seven_working_day);
                                    
                                    $today_date = date("Ymd");
                                    
                                    
                                    if ($OVERPAYMENT > 0)
                                    {
                                        $sql_min_receipt_lit = "SELECT MIN(LIT_KEY) AS MIN_LIT_KEY
                                                                FROM CUSTOMER_COLLECTION_DETAIL
                                                                WHERE CUSTOMER_KEY = $login_userkey
                                                                AND RECEIPT_KEY = $RECEIPT_KEY";
                                        $res88 = mysqli_query($con,$sql_min_receipt_lit);
                                        $arr88 = mysqli_fetch_assoc($res88);
                                        $MIN_LIT_KEY = $arr88["MIN_LIT_KEY"];
                                        
                                        if ($MIN_LIT_KEY == $RECEIPT_LIT_KEY)
                                        {
                                            $TOTAL_COLLECTED = $TOTAL_COLLECTED + $OVERPAYMENT;
                                        }
                                    }
                                    
                                    $data_table1 .= "<tr>";
                                    $data_table1 .= "<td style='border-top:1px solid Transparent;'></td>";
                                    $data_table1 .= "<td>Receipt</td>";
                                    
                                    if ($seven_working_day < $today_date) 
                                    {
                                        $data_table1 .= "<td><a href='javascript:void(0);' onclick='receipt_form(" . $RECEIPT_KEY . ")'>" . $RECEIPT_NO . "</a></td>";
                                    }
                                    else
                                    {
                                        $data_table1 .= "<td>" . $RECEIPT_NO . '<i>(Payment Accepted for Processing)</i>' . "</td>";
                                    }
                                    
                                    $data_table1 .= "<td>" . '(' . number_format($TOTAL_COLLECTED, 2) . ')' . "</td>";
                                    $data_table1 .= "</tr>";
                                    $count_invoice++;
                                    
                                    $GRAND_TOTAL = $GRAND_TOTAL - $TOTAL_COLLECTED;
                                }
                            }
                            
                            //Scholarship
                            $sql_scholarship = mysqli_query($con, "SELECT DISTINCT SUM(ALL CREDIT_AMOUNT) AS TOTAL_SCHOLARSHIP
                                                                   FROM CUSTOMER_VOUCHER
                                                                   WHERE CUSTOMER_KEY = $login_userkey
                                                                   AND LIT_KEY = " . $res_cohort_term['LIT_KEY'] . "
                                                                   AND VOUCHER_STATUS = 'Active'
                                                                   AND CREDIT_AMOUNT > 0");
                            if (mysqli_num_rows($sql_scholarship) > 0) 
                            {
                                while ($res_sql_scholarship = mysqli_fetch_assoc($sql_scholarship)) 
                                {
                                    $TOTAL_SCHOLARSHIP = $res_sql_scholarship['TOTAL_SCHOLARSHIP'];
                                    
                                    if ($TOTAL_SCHOLARSHIP > 0)
                                    {
                                        $data_table1 .= "<tr>";
                                        $data_table1 .= "<td style='border-top:1px solid Transparent;'></td>";
                                        $data_table1 .= "<td>Scholarship</td>";
                                        $data_table1 .= "<td></td>";
                                        $data_table1 .= "<td>" . '(' . number_format($TOTAL_SCHOLARSHIP, 2) . ')' . "</td>";
                                        $data_table1 .= "</tr>";
                                        $count_invoice++;
                                        
                                        $GRAND_TOTAL = $GRAND_TOTAL - $TOTAL_SCHOLARSHIP;
                                    }
                                }
                            }
                        }
                        
                        $data2 .= '<div class="card-body">
                                       <div>
                                           <h3>' . $DISPLAY . '</h3>
                                       </div>
                                       <div class="table-responsive">
                                           <table class="table table-bordered">
                                               <thead>
                                                   <tr class="table-primary">
                                                       <th style="width: 30%">Term</th>
                                                       <th style="width: 15%">Category</th>
                                                       <th style="width: 35%">Document</th>
                                                       <th style="width: 20%">Amount</th>
                                                   </tr>
                                               </thead>
                                               <tbody>
                                                   ' . $data_table1 . '
                                               </tbody>
                                           </table>
                                       </div>
                                       <i><p>*Payment Accepted for Processing: Kindly allow between 5 - 7 working days for update.</p></i>
                                       <i><p>**Disclaimer: The information shown is correct at the time of printing/viewing (' . date('d F Y h:i:s a', time()) . ')**</p></i>
                                   </div>';
                        $count++;
                        
                        $SUMMARY_GRAND_TOTAL = $SUMMARY_GRAND_TOTAL + $GRAND_TOTAL;
                        
                        if ($GRAND_TOTAL >= 0)
                        {
                            $GRAND_TOTAL_DISPLAY = number_format($GRAND_TOTAL, 2);
                        }
                        else
                        {
                            $GRAND_TOTAL_DISPLAY = $GRAND_TOTAL * -1;
                            $GRAND_TOTAL_DISPLAY =  '(' . number_format($GRAND_TOTAL_DISPLAY, 2) . ')';
                        }
                        
                        $summary_table .= '<tr class="table-success">
                                               <td style="width: 80%">' . $LEVEL_DESCRIPTION . ' (' . $LEVEL_CODE . ') - ' . $INTAKE_NO_DISPLAY . '</td>
                                               <td style="width: 20%">' . $GRAND_TOTAL_DISPLAY . '</td>
                                           </tr>';
                    }
                }
                
                
                if ($SUMMARY_GRAND_TOTAL >= 0)
                {
                    $SUMMARY_GRAND_TOTAL_DISPLAY = number_format($SUMMARY_GRAND_TOTAL, 2);
                }
                else
                {
                    $SUMMARY_GRAND_TOTAL_DISPLAY = $SUMMARY_GRAND_TOTAL * -1;
                    $SUMMARY_GRAND_TOTAL_DISPLAY =  '(' . number_format($SUMMARY_GRAND_TOTAL_DISPLAY, 2) . ')';
                }
                
                if ($TOTAL_VOUCHER_AMOUNT <= 0)
                {
                    $summary_table .= '<tr class="table-success">
                                           <td><b>Total : </b></td>
                                           <td><b>' . $SUMMARY_GRAND_TOTAL_DISPLAY . '</b></td>
                                       </tr>';
                    
                    $GRAND_GRAND_TOTAL = 0;
                }
                else
                {
                    $AVAILABLE_VOUCHER = '(' . number_format($TOTAL_VOUCHER_AMOUNT, 2) . ')';
                    
                    $GRAND_GRAND_TOTAL = $SUMMARY_GRAND_TOTAL - $TOTAL_VOUCHER_AMOUNT;
                    
                    if ($GRAND_GRAND_TOTAL >= 0)
                    {
                        $GRAND_GRAND_TOTAL_DISPLAY = number_format($GRAND_GRAND_TOTAL, 2);
                    }
                    else
                    {
                        $GRAND_GRAND_TOTAL_DISPLAY = $GRAND_GRAND_TOTAL * -1;
                        $GRAND_GRAND_TOTAL_DISPLAY =  '(' . number_format($GRAND_GRAND_TOTAL_DISPLAY, 2) . ')';
                    }
                    
                    $summary_table .= '<tr class="table-success">
                                           <td>Available Scholarship : </td>
                                           <td>' . $AVAILABLE_VOUCHER . '</td>
                                       </tr>
                                       <tr class="table-success">
                                           <td><b>Total : </b></td>
                                           <td><b>' . $GRAND_GRAND_TOTAL_DISPLAY . '</b></td>
                                       </tr>';
                }
                
                
                ?>
                <div class="card">
                    <div class="card-body">
                        <div>
                            <h3>
                                <u>Total Outstanding Fees</u><br /><?php echo $OUTSTANDING_DISPLAY ?>
                                <br />
                                <br />
                                <u>Total Overpayment Balance</u><br /><?php echo $OVERPAYMENT_DISPLAY ?>
                                <br />
                                <br />
                                <u>Total Scholarship Balance</u><br /><?php echo $TOTAL_VOUCHER_AMOUNT_DISPLAY ?>
                            </h3>
                        </div>
                        <i>**Disclaimer: The information shown is correct at the time of printing/viewing (<?php echo date('d F Y h:i:s a', time()) ?>)**</i>
                    </div>
                </div>
                <br />
                <div class="card">
                    <div class="card-body">
                        <div>
                            <h3><u>Fee Summary</u></h3>
                        </div>
                        <table class="table table-bordered">
                            <tbody>
                                <?php echo $summary_table; ?>
                            </tbody>
                        </table>
                        <i>**Disclaimer: The information shown is correct at the time of printing/viewing (<?php echo date('d F Y h:i:s a', time()) ?>)**</i>
                    </div>
                </div>
                <br />
                
                
                <?php 
                if ($GRAND_GRAND_TOTAL < 99999)
                {
                    $campus_sql = mysqli_query($con, "SELECT DISTINCT COMPANY_NAME, CAMPUS_NAME, REPLACE(CAMPUS_ADDRESS, '\r\n', ' ') CAMPUS_ADDRESS, CAMPUS_TEL_NO, CAMPUS_FAX, CAMPUS_EMAIL, COMPANY_BANK, COMPANY_ACCOUNT, COMPANY_ACCOUNT_NAME FROM CAMPUS_SETUP");
                    $campus_res = mysqli_fetch_array($campus_sql);
                    $CAMPUS_ADDRESS = $campus_res['CAMPUS_ADDRESS'];
                    $CAMPUS_TEL_NO = $campus_res['CAMPUS_TEL_NO'];
                    $CAMPUS_FAX = $campus_res['CAMPUS_FAX'];
                    $CAMPUS_EMAIL = $campus_res['CAMPUS_EMAIL'];
                    $COMPANY_NAME = $campus_res['COMPANY_NAME'];
                    $CAMPUS_NAME = $campus_res['CAMPUS_NAME'];
                    $COMPANY_BANK = $campus_res['COMPANY_BANK'];
                    $COMPANY_ACCOUNT = $campus_res['COMPANY_ACCOUNT'];
                    $COMPANY_ACCOUNT_NAME = $campus_res['COMPANY_ACCOUNT_NAME'];
                ?>
                <div class="card">
                    <div class="card-body">
                        <div>
                            <h3><u>Payment Method</u></h3>
                        </div>
                        <div>
                                Make all cheques payable to <strong><?php echo $COMPANY_ACCOUNT_NAME; ?></strong>. Write student name & ID no. and contact no. at the back of the cheque.
                                <br />
                                <br />
                                Official Receipts will only be issued upon clearance of cheque.
                                <br />
                                <br />
                                If you choose direct deposit or transfer, bank into <strong style="font-size:14pt;"><?php echo $COMPANY_BANK; ?></strong>, account no. <strong style="font-size:14pt;"><?php echo $COMPANY_ACCOUNT; ?></strong>. Write student name & ID no. and contact no. on the bank-in slip or transfer slip and fax to <?php echo $CAMPUS_FAX; ?> or email to <?php echo $CAMPUS_EMAIL; ?>. <strong>Make sure the ORIGINAL DEPOSIT OR TRANSFER SLIP is SUBMITTED TO FINANCE DEPT when student returns to college.</strong>
                        </div>
                    </div>
                </div>
                <br />
                <?php 
                }
                ?>
                
                
                <div class="card">
                    <?php echo isset($data2) ? $data2 : ""; ?>
                </div>
                <br />
            </div>
            <!--/.col (left) -->
        </div>
        <!-- /.row -->

    </div>
</div>
<form id="invoice_form" method="post" action="student_invoice_printing.php" target="_blank">
    <input type="hidden" id="INVOICE_KEY" name="INVOICE_KEY" />
    <input type="hidden" id="LIT_KEY" name="LIT_KEY" />
</form>
<form id="receipt_form" method="post" action="student_receipt_printing.php" target="_blank">
    <input type="hidden" id="RECEIPT_KEY" name="RECEIPT_KEY" />
</form>

<form id="creditnote_form" method="post" action="student_cn_printing.php" target="_blank">
    <input type="hidden" id="CN_NO" name="CN_NO" />
</form>
<form id="debitnote_form" method="post" action="student_dn_printing.php" target="_blank">
    <input type="hidden" id="DN_NO" name="DN_NO" />
</form>

<script>
    function invoice_form(LIT_KEY, INVOICE_KEY) {
        document.getElementById("LIT_KEY").value = LIT_KEY;
        document.getElementById("INVOICE_KEY").value = INVOICE_KEY;
        document.getElementById("invoice_form").submit();
    }

    function receipt_form(RECEIPT_KEY) {
        document.getElementById("RECEIPT_KEY").value = RECEIPT_KEY;
        document.getElementById("receipt_form").submit();
    }
    
    function creditnote_form(CREDITNOTE) {
        document.getElementById("CN_NO").value = CREDITNOTE;
        document.getElementById("creditnote_form").submit();
    }
    
    function debitnote_form(DEBITNOTE) {
        document.getElementById("DN_NO").value = DEBITNOTE;
        document.getElementById("debitnote_form").submit();
    }
</script>
<?php
include('portal_footer.php');
?>