<?php
//session_start();
ini_set('max_execution_time', 1500); //300 seconds = 5 minutes
ini_set('max_execution_time', 0); //0=NOLIMIT
ini_set('memory_limit', '1024M');
ini_set("pcre.backtrack_limit", "50000000");

include('session_verify.php');
include('db_config.php');
include("report_function.php");
require_once 'vendor/autoload.php';

$P_CUSTOMER_KEY = $login_userkey;

if (isset($_POST["P_LEVEL_KEY"]) && isset($_POST["P_INTAKE_KEY"]) && isset($_POST["P_LIT_KEY"]))
{
    $P_LEVEL_KEY = $_POST["P_LEVEL_KEY"];
    $P_INTAKE_KEY = $_POST['P_INTAKE_KEY'];
    $P_LIT_KEY = $_POST['P_LIT_KEY'];
}
else
{
    echo "<script type= 'text/javascript'>window.location='main_index.php'</script>";
    exit;
}

$sql_a = "SELECT DISTINCT A.CAMPUS, A.CUSTOMER_KEY, A.CUSTOMER_NAME, A.IC_PASSPORT, A.CUSTOMER_NO, C.LEVEL_KEY, C.LEVEL_CODE, 
      C.INTAKE_KEY, C.INTAKE_NO, D.LIT_KEY, D.TERM_NO, D.CUSTOMER_LIT_KEY, B.CLASS_KEY, B.CLASS_CODE, E.TERM_AVERAGE
      FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_MASTER B, CUSTOMER_LEVEL_DETAILS C, CUSTOMER_LEVEL_SUBJECT D, 
      CUSTOMER_EXAM_RESULT E, TERM_MASTER F
      WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
      AND B.CUSTOMER_KEY = C.CUSTOMER_KEY
      AND B.LEVEL_KEY = C.LEVEL_KEY
      AND B.INTAKE_KEY = C.INTAKE_KEY
      AND C.CUSTOMER_LIT_KEY = D.CUSTOMER_LIT_KEY
      AND D.CUSTOMER_LIT_KEY = E.CUSTOMER_LIT_KEY
      AND D.LIT_KEY = F.LIT_KEY
      AND C.CUSTOMER_LEVEL_STATUS IN ('Active', 'Completed', 'Transfer In')
      AND D.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Resit', 'Repeat')
      AND C.LEVEL_CODE IN ('CAT', 'ACCAFIA')
      AND (D.LEVEL_KEY = $P_LEVEL_KEY)
      AND (D.INTAKE_KEY = $P_INTAKE_KEY)
      AND (D.LIT_KEY = $P_LIT_KEY)
      AND (A.CUSTOMER_KEY = $P_CUSTOMER_KEY OR $P_CUSTOMER_KEY IS NULL)
      ORDER BY A.CUSTOMER_NAME";
$result_a = mysqli_query($con,$sql_a)or die(mysqli_error($con));
$HTML = '<html>
            <head>
            <meta name="robots" content="noindex, nofollow">
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <style>
                  @page {
                        margin: 0;
                  }

                  body {
                        margin: 0;
                        font-family: Times New Roman;
                  }

                  .invoice-box {
                        max-width: 800px;
                        margin: auto;
                        padding: 20px;
                        line-height:normal;
                        color: #000;
                        padding:0px 50px;
                  }
                  .report_title{
                        font-weight: bold;
                        font-size: 16px;
                        line-height: normal;
                        padding: 10px 0;
                  }
                  .report_content table{
                        font-size: 12px;
                        line-height:20px;
                  }
                  .report_content th{
                        text-align: left;
                  }
                  .report_summry {
                        padding-top: 20px;
                  }
                  .report_summry table{
                        font-size: 10px;
                        line-height:20px;
                        border: 1px solid #000;
                        border-right: 0px solid #000;
                        width: 100%;
                  }
                  .report_summry table tr th{
                        padding:3px;
                        border-bottom: 1px solid #000;
                        border-right: 1px solid #000;
                  }
                  .report_summry table tr td{
                        font-size:10px;
                        padding:3px;
                        text-align:center;
                        border-right: 1px solid #000;
                  }

                  .report_summry_content {
                        padding-top: 20px;
                  }
                  .report_summry_content table{
                        font-size: 10px;
                        line-height:20px;
                        border: 0px solid #000;
                        border-bottom: 1px solid #000;
                        border-right: 1px solid #000;
                        width: 100%;
                  }
                  .report_summry_content table tr th{
                        border: 1px solid #000;
                        border-right: 0px solid #000;
                        border-bottom: 0px solid #000;
                        padding:3px;
                  }
                  .report_summry_content table tr td{
                        border: 1px solid #000;
                        border-right: 0px solid #000;
                        border-bottom: 0px solid #000;
                        font-size:10px;
                        padding:3px;
                        text-align:center;
                  }

                  .report_summry_content_comment {
                        padding-top: 20px;
                  }
                  .report_summry_content_comment table{
                        font-size: 10px;
                        line-height:20px;
                        border: 0px solid #000;
                        border-bottom: 1px solid #000;
                        border-right: 1px solid #000;
                        width: 100%;
                  }
                  .report_summry_content_comment table tr th{
                        border: 1px solid #000;
                        border-right: 0px solid #000;
                        border-bottom: 0px solid #000;
                        padding:3px;
                  }
                  .report_summry_content_comment table tr td{
                        border: 1px solid #000;
                        border-right: 0px solid #000;
                        border-bottom: 0px solid #000;
                        font-size:10px;
                        padding:3px;
                        text-align:center;
                  }
            </style>
            <title>ACCAFIA Exam Statement Print</title>
            </head>
            <body>';
$i=0;
while($arr_a=mysqli_fetch_assoc($result_a))
{
      $CAMPUS = $arr_a["CAMPUS"];
      $CUSTOMER_KEY = $arr_a["CUSTOMER_KEY"];
      $CUSTOMER_NAME = $arr_a["CUSTOMER_NAME"];
      $IC_PASSPORT = $arr_a["IC_PASSPORT"];
      $CUSTOMER_NO = $arr_a["CUSTOMER_NO"];
      $LEVEL_KEY = $arr_a["LEVEL_KEY"];
      $LEVEL_CODE = $arr_a["LEVEL_CODE"];
      $INTAKE_KEY = $arr_a["INTAKE_KEY"];
      $INTAKE_NO = $arr_a["INTAKE_NO"];
      $LIT_KEY = $arr_a["LIT_KEY"];
      $TERM_NO = $arr_a["TERM_NO"];
      $CUSTOMER_LIT_KEY = $arr_a["CUSTOMER_LIT_KEY"];
      $CLASS_KEY = $arr_a["CLASS_KEY"];
      $CLASS_CODE = $arr_a["CLASS_CODE"];
      $TERM_AVERAGE = $arr_a["TERM_AVERAGE"];
      
      if ($CAMPUS == 'MCKL')
            $LOGO_IMAGE = 'MCKL_Logo1.png';
      else
            $LOGO_IMAGE = 'MCKL_Logo2.png';


      if (strlen($IC_PASSPORT) == 12)
      $IC_PASSPORT_DISPLAY = substr($IC_PASSPORT,0,6).'-'.substr($IC_PASSPORT,6,2).'-'.substr($IC_PASSPORT,8);
      else
      $IC_PASSPORT_DISPLAY = $IC_PASSPORT;


      $sql_level_desc = "SELECT DISTINCT UPPER(LEVEL_DESCRIPTION) AS RESULT
      FROM LEVEL_MASTER
      WHERE LEVEL_KEY = $LEVEL_KEY";
      $res88 = mysqli_query($con,$sql_level_desc);
      $arr88 = mysqli_fetch_assoc($res88);
      $LEVEL_DESC = $arr88["RESULT"];


      $YEAR_OF_ENTRY = substr($INTAKE_NO,0,4);

      $V_RUNNING = 1;

      $sql_b = "SELECT DISTINCT D.CUSTOMER_LIT_SUBJECT_KEY, D.SUBJECT_KEY, IFNULL(D.GROUP_KEY,0) GROUP_KEY, 
            REPLACE(D.SUBJECT_CODE,'(A)', '') SUBJECT_CODE, LENGTH(REPLACE(D.SUBJECT_CODE,'(A)', '')) SUBJECT_LENGTH, D.SUBJECT_DESCRIPTION, 
            (CASE IFNULL(D.SUBJECT_FINAL_MARKS,-2) WHEN -2 THEN 22 ELSE 1 END) SUBJECT_ORDER,
            D.SUBJECT_FINAL_MARKS, D.SUBJECT_GRADE, D.GRADING_POINT, D.GRADING_KEY
            FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_MASTER B, CUSTOMER_LEVEL_DETAILS C, CUSTOMER_LEVEL_SUBJECT D, 
            CUSTOMER_EXAM_RESULT E, TERM_MASTER F
            WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
            AND B.CUSTOMER_KEY = C.CUSTOMER_KEY
            AND B.LEVEL_KEY = C.LEVEL_KEY
            AND B.INTAKE_KEY = C.INTAKE_KEY
            AND C.CUSTOMER_LIT_KEY = D.CUSTOMER_LIT_KEY
            AND D.CUSTOMER_LIT_KEY = E.CUSTOMER_LIT_KEY
            AND D.LIT_KEY = F.LIT_KEY
            AND C.CUSTOMER_LEVEL_STATUS IN ('Active', 'Completed', 'Transfer In')
            AND D.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Resit', 'Repeat')
            AND C.LEVEL_CODE IN ('CAT', 'ACCAFIA')
            AND D.SUBJECT_CODE NOT IN ('IELTS', 'MUET')
            AND D.SUBJECT_CODE NOT LIKE 'ICDL%'
            AND D.SUBJECT_CODE NOT LIKE 'IVY%'
            AND (C.CUSTOMER_LIT_KEY = $CUSTOMER_LIT_KEY)
      ORDER BY SUBJECT_LENGTH, SUBJECT_ORDER, D.SUBJECT_DESCRIPTION";
      $result_b = mysqli_query($con,$sql_b)or die(mysqli_error($con));
      $HTML_REPORT_SUMMERY = "";
      while($arr_b=mysqli_fetch_assoc($result_b))
      {
            $CUSTOMER_LIT_SUBJECT_KEY = $arr_b["CUSTOMER_LIT_SUBJECT_KEY"];
            $SUBJECT_KEY = $arr_b["SUBJECT_KEY"];
            $GROUP_KEY = $arr_b["GROUP_KEY"];
            $SUBJECT_CODE = $arr_b["SUBJECT_CODE"];
            $SUBJECT_DESCRIPTION = $arr_b["SUBJECT_DESCRIPTION"];
            $SUBJECT_FINAL_MARKS = $arr_b["SUBJECT_FINAL_MARKS"];
            $SUBJECT_GRADE = $arr_b["SUBJECT_GRADE"];
            $GRADING_POINT = $arr_b["GRADING_POINT"];
            $GRADING_KEY = $arr_b["GRADING_KEY"];

            $sql_mpu = "SELECT DISTINCT IFNULL(MQA_SUBJECT,'N') AS RESULT
            FROM SUBJECT_MASTER
            WHERE SUBJECT_KEY = $SUBJECT_KEY";
            $res88 = mysqli_query($con,$sql_mpu);
            $arr88 = mysqli_fetch_assoc($res88);
            $MPU_SUBJECT = $arr88["RESULT"];

            if ($MPU_SUBJECT == 'Y')
            $FINAL_MARKS_DISPLAY = " ";
            else
            $FINAL_MARKS_DISPLAY = $SUBJECT_FINAL_MARKS;

            $HTML_REPORT_SUMMERY .= '<tr>
                  <td>'.$V_RUNNING.'</td>
                  <td>'.$SUBJECT_CODE.'</td>
                  <td>'.$SUBJECT_DESCRIPTION.'</td>
                  <td>'.number_format($FINAL_MARKS_DISPLAY).'</td>
                  <td class="b-r0">'.$SUBJECT_GRADE.'</td>
            </tr>';

            $V_RUNNING++;
      }

      $HTML_REPORT_SUMMERY_FOOTER = "";
      for ($x = $V_RUNNING; $x <= 10; $x++) 
      {
            $HTML_REPORT_SUMMERY_FOOTER .='<tr>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td>&nbsp;</td>
                  <td class="b-r0">&nbsp;</td>
            </tr>';
      }


      //Start from here will be PERFORMANCE REPORT, each student will have multiple page
      $sql_c = "SELECT DISTINCT D.CUSTOMER_LIT_SUBJECT_KEY, D.SUBJECT_KEY, REPLACE(D.SUBJECT_CODE,'(A)', '') SUBJECT_CODE, D.SUBJECT_DESCRIPTION, 
            D.SUBJECT_FINAL_MARKS, D.SUBJECT_GRADE, D.GRADING_POINT, D.GRADING_KEY, 
            E.EVALUATE_KEY, D.ACCA_ATTENDANCE, D.ACCA_ASSIGNMENT_TEST, D.ACCA_OTHERS
            FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_MASTER B, CUSTOMER_LEVEL_DETAILS C, CUSTOMER_LEVEL_SUBJECT D, 
            CUSTOMER_EXAM_MASTER E, EVALUATE_MASTER F, TERM_MASTER G
            WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
            AND B.CUSTOMER_KEY = C.CUSTOMER_KEY
            AND B.LEVEL_KEY = C.LEVEL_KEY
            AND B.INTAKE_KEY = C.INTAKE_KEY
            AND C.CUSTOMER_LIT_KEY = D.CUSTOMER_LIT_KEY
            AND D.CUSTOMER_LIT_SUBJECT_KEY = E.CUSTOMER_LIT_SUBJECT_KEY
            AND E.EVALUATE_KEY = F.EVALUATE_KEY
            AND E.EVALUATE_MASTER_KEY = F.EVALUATE_MASTER_KEY
            AND D.LIT_KEY = G.LIT_KEY
            AND C.CUSTOMER_LEVEL_STATUS IN ('Active', 'Completed', 'Transfer In')
            AND D.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Resit', 'Repeat')
            AND D.SUBJECT_CODE NOT IN ('SER1100', 'SER1000', 'SSC1010', 'MPU1153', 'MPU1133', 'GEN1020', 'IELTS', 'MPU 2213', 'MUET')
            AND C.LEVEL_CODE IN ('CAT', 'ACCAFIA')
            AND D.SUBJECT_CODE NOT LIKE 'ICDL%'
            AND D.SUBJECT_CODE NOT LIKE 'IVY%'
            AND (C.CUSTOMER_LIT_KEY = $CUSTOMER_LIT_KEY)
            ORDER BY D.SUBJECT_DESCRIPTION";
      $result_c = mysqli_query($con,$sql_c)or die(mysqli_error($con));
      $HTML_REPORT_CONTENT = "";
      while($arr_c = mysqli_fetch_assoc($result_c))
      {
            $CUSTOMER_LIT_SUBJECT_KEY = $arr_c["CUSTOMER_LIT_SUBJECT_KEY"];
            $SUBJECT_KEY = $arr_c["SUBJECT_KEY"];
            $SUBJECT_CODE = $arr_c["SUBJECT_CODE"];
            $SUBJECT_DESCRIPTION = $arr_c["SUBJECT_DESCRIPTION"];
            $SUBJECT_FINAL_MARKS = $arr_c["SUBJECT_FINAL_MARKS"];
            $SUBJECT_GRADE = $arr_c["SUBJECT_GRADE"];
            $GRADING_POINT = $arr_c["GRADING_POINT"];
            $GRADING_KEY = $arr_c["GRADING_KEY"];
            $EVALUATE_KEY = $arr_c["EVALUATE_KEY"];
            $ACCA_ATTENDANCE = $arr_c["ACCA_ATTENDANCE"];
            $ACCA_ASSIGNMENT_TEST = $arr_c["ACCA_ASSIGNMENT_TEST"];
            $ACCA_OTHERS = $arr_c["ACCA_OTHERS"];

            $LECTURER = " ";

            $sql_lecturer = "SELECT DISTINCT A.LECTURER_NAME, IFNULL(A.LECTURER_MASTER,'N') LECTURER_MASTER
            FROM SUBJECT_LECTURER_DETAIL A, TERM_MASTER B
            WHERE A.LIT_KEY = B.LIT_KEY
            AND A.LIT_KEY = $LIT_KEY
            AND A.SUBJECT_KEY = $SUBJECT_KEY
            ORDER BY IFNULL(A.LECTURER_MASTER,'N') DESC";
            $result_lecturer = mysqli_query($con,$sql_lecturer)or die(mysqli_error($con));
            while($arr_lecturer = mysqli_fetch_assoc($result_lecturer))
            {
                  $LECTURER_NAME = $arr_lecturer["LECTURER_NAME"];

                  if ($LECTURER == " ")
                  {
                        $LECTURER = $LECTURER_NAME;
                  }
                  else
                  {
                        $LECTURER = $LECTURER.", ".$LECTURER_NAME;
                  }
            }

            $sql_term_end = "SELECT DISTINCT DATE_FORMAT(TERM_END_DATE, '%Y%m%d') TERM_END_DATE_COMPARE,DATE_FORMAT(TERM_END_DATE, '%d/%m/%Y') TERM_END_DATE FROM TERM_MASTER WHERE LIT_KEY = $LIT_KEY";
            $res88 = mysqli_query($con,$sql_term_end);
            $arr88 = mysqli_fetch_assoc($res88);
            $TERM_END_DATE_COMPARE = $arr88["TERM_END_DATE_COMPARE"];
            $TERM_END_DATE = $arr88["TERM_END_DATE"];

            if ($TERM_END_DATE_COMPARE <= date("Ymd"))
                  $TERM_END_DATE = $TERM_END_DATE;
            else
                  $TERM_END_DATE = date("d/m/Y");


            $sql_d = "SELECT DISTINCT E.EVALUATE_MASTER_KEY, F.SEQ_NO, E.EVALUATE_TYPE, F.EXAM_MARKS MAX_MARKS, F.EVALUATE_PERCENTAGE WEIGHTING, 
                  E.EXAM_MARKS, E.EVALUATE_PERCENTAGE
                  FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_MASTER B, CUSTOMER_LEVEL_DETAILS C, CUSTOMER_LEVEL_SUBJECT D, 
                  CUSTOMER_EXAM_MASTER E, EVALUATE_MASTER F, TERM_MASTER G
                  WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
                  AND B.CUSTOMER_KEY = C.CUSTOMER_KEY
                  AND B.LEVEL_KEY = C.LEVEL_KEY
                  AND B.INTAKE_KEY = C.INTAKE_KEY
                  AND C.CUSTOMER_LIT_KEY = D.CUSTOMER_LIT_KEY
                  AND D.CUSTOMER_LIT_SUBJECT_KEY = E.CUSTOMER_LIT_SUBJECT_KEY
                  AND E.EVALUATE_KEY = F.EVALUATE_KEY
                  AND E.EVALUATE_MASTER_KEY = F.EVALUATE_MASTER_KEY
                  AND D.LIT_KEY = G.LIT_KEY
                  AND C.CUSTOMER_LEVEL_STATUS IN ('Active', 'Completed', 'Transfer In')
                  AND D.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Resit', 'Repeat')
                  AND D.SUBJECT_CODE NOT IN ('SER1100', 'SER1000', 'SSC1010', 'MPU1153', 'MPU1133', 'GEN1020', 'IELTS', 'MPU 2213', 'MUET')
                  AND C.LEVEL_CODE IN ('CAT', 'ACCAFIA')
                  AND D.SUBJECT_CODE NOT LIKE 'ICDL%'
                  AND D.SUBJECT_CODE NOT LIKE 'IVY%'
                  AND (D.CUSTOMER_LIT_SUBJECT_KEY = $CUSTOMER_LIT_SUBJECT_KEY)
                  ORDER BY F.SEQ_NO, E.EVALUATE_TYPE";
            $result_d = mysqli_query($con,$sql_d)or die(mysqli_error($con));
            $HTML_SUMMERY_CONTENT = "";
            while($arr_d = mysqli_fetch_assoc($result_d))
            {
                  $EVALUATE_MASTER_KEY = $arr_d["EVALUATE_MASTER_KEY"];
                  $SEQ_NO = $arr_d["SEQ_NO"];
                  $EVALUATE_TYPE = $arr_d["EVALUATE_TYPE"];
                  $MAX_MARKS = $arr_d["MAX_MARKS"];
                  $WEIGHTING = $arr_d["WEIGHTING"];
                  $EXAM_MARKS = $arr_d["EXAM_MARKS"];
                  $EVALUATE_PERCENTAGE = $arr_d["EVALUATE_PERCENTAGE"];
                  $SCORE_DISPLAY = $EVALUATE_TYPE.' ('.number_format($WEIGHTING).'%)';

                  if($EVALUATE_PERCENTAGE==""){
                        $EVALUATE_PERCENTAGE = "";
                  }else{
                        $EVALUATE_PERCENTAGE = number_format($EVALUATE_PERCENTAGE,2);
                  }

                  $HTML_SUMMERY_CONTENT .= '<tr>
                        <td style="text-align:left;">'.$SCORE_DISPLAY.'</td>
                        <td>'.$EVALUATE_PERCENTAGE.'</td>
                  </tr>';
            }


            $HTML_REPORT_CONTENT .= '<div style="page-break-before:always;">&nbsp;</div>
                  <div class="invoice-box">
                        <div style="width:100%;">
                              <div class="logo">
                                    <img src="Image/'.$LOGO_IMAGE.'" style="width:100%; max-width:220px; margin-right:0px;">
                              </div>
                              <div class="report_title">
                                    <span>'.$LEVEL_DESC.' ('.$LEVEL_CODE.')</span>
                              </div>
                              <div class="report_title">
                                    <span>PERFORMANCE REPORT</span>
                              </div>
                        </div>                   
                        <div style="width:100%;" class="report_content">
                              <table style="width:100%;" cellspacing="0" cellpadding="0">
                                    <tr>
                                          <th style="width:150px;">Name of Student</th>
                                          <tH style="width:10px;">:</th>
                                          <th>'.$CUSTOMER_NAME.'</th>
                                    </tr>
                                    <tr>
                                          <th>Cohort</th>
                                          <th>:</th>
                                          <th>'.$LEVEL_CODE.' '.$INTAKE_NO.'</th>
                                    </tr>
                                    <tr>
                                          <th>Name of Lecturer</th>
                                          <th>:</th>
                                          <th>'.$LECTURER.'</th>
                                    </tr>
                                    <tr>
                                          <th>Date</th>
                                          <th>:</th>
                                          <th>'.$TERM_END_DATE.'</th>
                                    </tr>
                              </table>
                        </div>
                        <div style="width:100%;" class="report_summry_content">
                              <table cellspacing="0" cellpadding="0">
                                    <tbody>
                                          <tr>
                                                <td style="text-align:left;">Tests Scores (%)</td>
                                                <td>Subject : '.$SUBJECT_CODE.' '.$SUBJECT_DESCRIPTION.'</td>
                                          </tr>
                                          '.$HTML_SUMMERY_CONTENT.'
                                          <tr>
                                                <th style="text-align:left;">Overall Score (100%)</th>
                                                <th>'.number_format($SUBJECT_FINAL_MARKS).'</th>
                                          </tr>
                                    </tbody>                                    
                              </table>
                        </div>
                        <div style="width:100%;" class="report_summry_content_comment">
                              <table cellspacing="0" cellpadding="0">
                                    <tbody>
                                          <tr>
                                                <th colspan="2" style="font-size:12px;border-bottom: 1px solid #000;">Comment</th>
                                          </tr>
                                          <tr>
                                                <td style="text-align:center;width:120px;">Attendance:</td>
                                                <td style="text-align:left;padding-left:5px;">'.$ACCA_ATTENDANCE.'</td>
                                          </tr>
                                          <tr>
                                                <td colspan="2" style="line-height:5px;border-right:0px;"></td>
                                          </tr>
                                          <tr>
                                                <td style="text-align:center;">Assignments / Tests :</td>
                                                <td style="text-align:left;padding-left:5px;">'.$ACCA_ASSIGNMENT_TEST.'</td>
                                          </tr>
                                          <tr>
                                                <td colspan="2" style="line-height:5px;border-right:0px;"></td>
                                          </tr>
                                          <tr>
                                                <td style="text-align:center;">Others :</td>
                                                <td style="text-align:left;padding-left:5px;">'.$ACCA_OTHERS.'</td>
                                          </tr>
                                    </tbody>                                    
                              </table>
                        </div>
                   </div>';
      }

      $PageBrake = '';
      $STYLE_PADDING = '';
      if($i!=0){
            $PageBrake .= '<div style="page-break-before:always;">&nbsp;</div>';
      }
      if($i==0){
          $STYLE_PADDING = 'padding-top:19.5px;';
      }
      $i++;

      $HTML .= $PageBrake.'
            <div class="invoice-box">
                  <div style="width:100%;'.$STYLE_PADDING.'">
                        <div class="logo">
                              <img src="Image/'.$LOGO_IMAGE.'" style="width:100%; max-width:220px; margin-right:0px;">
                        </div>
                        <div class="report_title">
                              <span>'.$LEVEL_DESC.' ('.$LEVEL_CODE.')</span>
                        </div>
                        <div class="report_title">
                              <span>STATEMENT OF SEMESTER RESULTS</span>
                        </div>
                  </div>                   
                  <div style="width:100%;" class="report_content">
                        <table style="width:100%;" cellspacing="0" cellpadding="0">
                              <tr>
                                    <th style="width:150px;">Name of Student</th>
                                    <td style="width:10px;">:</td>
                                    <td>'.$CUSTOMER_NAME.'</td>
                              </tr>
                              <tr>
                                    <th>NRIC/Passport</th>
                                    <td>:</td>
                                    <td>'.$IC_PASSPORT.'</td>
                              </tr>
                              <tr>
                                    <th>ID ( Cohort )</th>
                                    <td>:</td>
                                    <td>'.$CUSTOMER_NO.'</td>
                              </tr>
                              <tr>
                                    <th>Semester</th>
                                    <td>:</td>
                                    <td>'.number_format($TERM_NO).'</td>
                              </tr>
                              <tr>
                                    <th>Year of Entry</th>
                                    <td>:</td>
                                    <td>'.$YEAR_OF_ENTRY.'</td>
                              </tr>
                        </table>
                  </div>
                  <div style="width:100%;" class="report_summry">
                        <table cellspacing="0" cellpadding="0">
                              <thead>
                                    <tr>
                                          <th style="width:35px;">No.</th>
                                          <th style="width:110px;">Subject Code</th>
                                          <th>Subject</th>
                                          <th style="width:100px;">Total Marks</th>
                                          <th  style="width:100px;" class="b-r0">Grade</th>
                                    </tr>
                              </thead>                                    
                              <tbody>
                                    '.$HTML_REPORT_SUMMERY.'
                                    '.$HTML_REPORT_SUMMERY_FOOTER.'
                                    <tr>
                                          <td style="border-top:1px solid #000;border-bottom: 1px solid #000;border-right:0px;">&nbsp;</td>
                                          <td style="border-top:1px solid #000;border-bottom: 1px solid #000;border-right:0px;">&nbsp;</td>
                                          <td style="border-top:1px solid #000;border-bottom: 1px solid #000;border-right:0px;">&nbsp;</td>
                                          <td style="border-top:1px solid #000;border-bottom: 1px solid #000;border-right:0px;">&nbsp;</td>
                                          <td style="border-top:1px solid #000;border-bottom: 1px solid #000;"></td>
                                    </tr>
                                    <tr>
                                          <td colspan="3" style="text-align:left;" >Overall Result :</td>
                                          <td style="text-align:right;font-weight:bold;">Average</td>
                                          <td class="b-r0">'.number_format($TERM_AVERAGE,2).'</td>
                                    </tr>
                              </tbody>
                        </table>
                  </div>
            </div>
            '.$HTML_REPORT_CONTENT.'

            ';

}

$HTML .= '</body></html>';

$footerdata = '<div style="margin:0px auto; width:100%;font-family: Helvetica Neue, Helvetica, Helvetica, Arial, sans-serif;font-size: 10px;">
            <div style="font-style: italic;text-align:center;padding-bottom:10px;">
              *This is a computer generated document and NO signature is required.
            </div>
      </div>';
//echo $html;exit;

$report_name = preg_replace('/[^a-zA-Z0-9_ -]/s', '', $CUSTOMER_NAME).".pdf";

$mpdf = new \Mpdf\Mpdf(['mode' => 'utf-8', 'format' => 'A4','0','',0,0,0,0,'margin_header' => 0,'orientation' => 'P']);
$mpdf->setAutoTopMargin = 'stretch';
$mpdf->setAutoBottomMargin = 'stretch';
$mpdf->AddPage('P','','','','',' ',' ',' ',' ',0,0);
$mpdf->SetHTMLFooter($footerdata);
$mpdf->WriteHTML($HTML);
$mpdf->SetProtection(array('print','print-highres'),'','[]mckl@0322741851&mcpg#042175088()');
$mpdf->Output($report_name,"I");
?>