<?php
set_time_limit(0);
ini_set('memory_limit', '1024M');
ini_set("pcre.backtrack_limit", "50000000");
include('session_verify.php');
include('db_config.php');
require_once('tcpdf/tcpdf.php');

$P_CUSTOMER_KEY = $login_userkey;

if (isset($_POST["P_LEVEL_KEY"]) && isset($_POST["P_INTAKE_KEY"]) && isset($_POST["P_LIT_KEY"]) && isset($_POST['P_CLASS_KEY']))
{
    $P_LEVEL_KEY = $_POST["P_LEVEL_KEY"];
    $P_INTAKE_KEY = $_POST['P_INTAKE_KEY'];
    $P_LIT_KEY = $_POST['P_LIT_KEY'];
    $P_CLASS_KEY = $_POST['P_CLASS_KEY'];
    
    $P_SUBJECT_KEY = 'NULL';
    $P_GROUP_KEY = 'NULL';
}
else
{
    echo "<script type= 'text/javascript'>window.location='main_index.php'</script>";
    exit;
}

$tbl = "";

global $CAMPUS;

$sql_a = "SELECT DISTINCT A.CAMPUS, A.CUSTOMER_KEY, A.CUSTOMER_NAME, A.IC_PASSPORT, A.CUSTOMER_NO, C.LEVEL_KEY, C.LEVEL_CODE, 
	C.INTAKE_KEY, C.INTAKE_NO, D.LIT_KEY, D.TERM_NO, D.CUSTOMER_LIT_KEY, B.CLASS_KEY, B.CLASS_CODE, E.GPA, E.CGPA
	FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_MASTER B, CUSTOMER_LEVEL_DETAILS C, CUSTOMER_LEVEL_SUBJECT D, 
	CUSTOMER_EXAM_RESULT E
	WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY AND B.CUSTOMER_KEY = C.CUSTOMER_KEY AND B.LEVEL_KEY = C.LEVEL_KEY
	AND B.INTAKE_KEY = C.INTAKE_KEY AND C.CUSTOMER_LIT_KEY = D.CUSTOMER_LIT_KEY AND D.CUSTOMER_LIT_KEY = E.CUSTOMER_LIT_KEY
	AND C.CUSTOMER_LEVEL_STATUS IN ('Active', 'Completed', 'Transfer In')
	AND D.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Resit', 'Repeat')
	AND D.SUBJECT_CODE NOT IN ('IELTS', 'TK', 'MUET', 'EPS', 'LCT', 'SIA') AND D.SUBJECT_CODE NOT LIKE 'ICDL%' AND D.SUBJECT_CODE NOT LIKE 'IVY%'
	AND ((C.LEVEL_KEY = $P_LEVEL_KEY)
	AND (C.INTAKE_KEY = $P_INTAKE_KEY) AND (IFNULL(B.CLASS_KEY,' ') = $P_CLASS_KEY OR $P_CLASS_KEY IS NULL)
	AND (D.LIT_KEY = $P_LIT_KEY) AND (A.CUSTOMER_KEY = $P_CUSTOMER_KEY OR $P_CUSTOMER_KEY IS NULL))
	AND A.CUSTOMER_KEY IN  (SELECT DISTINCT X.CUSTOMER_KEY FROM CUSTOMER_LEVEL_SUBJECT X WHERE X.CUSTOMER_LIT_KEY = C.CUSTOMER_LIT_KEY AND (X.SUBJECT_KEY = $P_SUBJECT_KEY OR $P_SUBJECT_KEY IS NULL)
	AND (X.GROUP_KEY = $P_GROUP_KEY OR $P_GROUP_KEY IS NULL))
	ORDER BY C.LEVEL_CODE, C.INTAKE_NO, D.TERM_NO, A.CUSTOMER_NAME";

$result_a = mysqli_query($con,$sql_a)or die(mysqli_error($con));
$i =0;
while($arr_a=mysqli_fetch_assoc($result_a))
{
	$CAMPUS = $arr_a["CAMPUS"];
    $CUSTOMER_KEY = $arr_a["CUSTOMER_KEY"];
	$CUSTOMER_NAME = $arr_a["CUSTOMER_NAME"];
	$IC_PASSPORT = $arr_a["IC_PASSPORT"];
	$CUSTOMER_NO = $arr_a["CUSTOMER_NO"];
	$LEVEL_KEY = $arr_a["LEVEL_KEY"];
	$LEVEL_CODE = $arr_a["LEVEL_CODE"];
	$INTAKE_KEY = $arr_a["INTAKE_KEY"];
	$INTAKE_NO = $arr_a["INTAKE_NO"];
	$LIT_KEY = $arr_a["LIT_KEY"];
	$TERM_NO = $arr_a["TERM_NO"];
	$CUSTOMER_LIT_KEY = $arr_a["CUSTOMER_LIT_KEY"];
	$CLASS_KEY = $arr_a["CLASS_KEY"];
	$CLASS_CODE = $arr_a["CLASS_CODE"];
	$GPA = $arr_a["GPA"];
	$CGPA = $arr_a["CGPA"];
    
	if(strlen($IC_PASSPORT) == 12)
		$IC_PASSPORT_DISPLAY = substr($IC_PASSPORT,0,6).'-'.substr($IC_PASSPORT,6,2).'-'.substr($IC_PASSPORT,8);
	else
		$IC_PASSPORT_DISPLAY = $IC_PASSPORT;

	$sql_semester = "SELECT DISTINCT CONCAT(DATE_FORMAT(TERM_START_DATE,'%b-%Y'),' - ',DATE_FORMAT(TERM_END_DATE,'%b-%Y')) AS SEMESTER_RANGE FROM TERM_MASTER WHERE LIT_KEY = '$LIT_KEY'";
	$res88 = mysqli_query($con,$sql_semester);
	$arr88 = mysqli_fetch_assoc($res88);
	$SEMESTER_RANGE = $arr88["SEMESTER_RANGE"];

	if ($LEVEL_CODE == 'PREPCAL')
	{
		if ($SEMESTER_RANGE != ' ')
			$SEMESTER_RANGE = 'Prep Programme ( '.$SEMESTER_RANGE.' )';
		else
			$SEMESTER_RANGE = 'Prep Programme';
	}
	else
	{
		if ($SEMESTER_RANGE != ' ')
			$SEMESTER_RANGE = 'Semester '.round($TERM_NO).' ( '.$SEMESTER_RANGE.' )';
		else
			$SEMESTER_RANGE = 'Semester '.round($TERM_NO);
	}
	$YEAR_OF_ENTRY = substr($INTAKE_NO,0,4);

	$V_RUNNING = 1;
	$CURRENT_GRADING_POINT = 0;

	$sql_cumulative = "SELECT SUM(ALL GRADING_POINT) AS RESULT FROM CUSTOMER_LEVEL_SUBJECT WHERE CUSTOMER_KEY = $CUSTOMER_KEY AND LEVEL_KEY = $LEVEL_KEY AND INTAKE_KEY = $INTAKE_KEY AND TERM_NO <= $TERM_NO AND CUSTOMER_SUBJECT_STATUS NOT IN ('Exempted', 'Withdrawn', 'Cancelled')";
	$res88 = mysqli_query($con,$sql_cumulative);
	$arr88 = mysqli_fetch_assoc($res88);
	$TOTAL_GRADING_POINTS = $arr88["RESULT"];

	$sql_b = "SELECT DISTINCT D.CUSTOMER_LIT_SUBJECT_KEY, D.SUBJECT_KEY, D.GROUP_KEY, D.SUBJECT_CODE, D.SUBJECT_DESCRIPTION, LENGTH(D.SUBJECT_CODE) SUBJECT_LENGTH, D.SUBJECT_FINAL_MARKS, D.SUBJECT_GRADE, D.GRADING_POINT, D.GRADING_KEY
		FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_MASTER B, CUSTOMER_LEVEL_DETAILS C, CUSTOMER_LEVEL_SUBJECT D, 
		CUSTOMER_EXAM_RESULT E
		WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
		AND B.CUSTOMER_KEY = C.CUSTOMER_KEY AND B.LEVEL_KEY = C.LEVEL_KEY AND B.INTAKE_KEY = C.INTAKE_KEY
		AND C.CUSTOMER_LIT_KEY = D.CUSTOMER_LIT_KEY AND D.CUSTOMER_LIT_KEY = E.CUSTOMER_LIT_KEY
		AND C.CUSTOMER_LEVEL_STATUS IN ('Active', 'Completed', 'Transfer In')
		AND D.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Resit', 'Repeat')
		AND D.SUBJECT_CODE NOT IN ('IELTS', 'TK', 'MUET', 'EPS', 'LCT', 'SIA')
		AND D.SUBJECT_CODE NOT LIKE 'ICDL%' AND D.SUBJECT_CODE NOT LIKE 'IVY%'
		AND ((C.LEVEL_KEY = $LEVEL_KEY) AND (C.INTAKE_KEY = $INTAKE_KEY) AND (D.LIT_KEY = $LIT_KEY)
		AND (A.CUSTOMER_KEY = $CUSTOMER_KEY)) ORDER BY SUBJECT_LENGTH, D.SUBJECT_DESCRIPTION";
	$result_b = mysqli_query($con,$sql_b)or die(mysqli_error($con));
	$SUBJECT_HTML = "";
	while($arr_b=mysqli_fetch_assoc($result_b))
	{
		$CUSTOMER_LIT_SUBJECT_KEY = $arr_b["CUSTOMER_LIT_SUBJECT_KEY"];
		$SUBJECT_KEY = $arr_b["SUBJECT_KEY"];
		$GROUP_KEY = $arr_b["GROUP_KEY"];
		$SUBJECT_CODE = $arr_b["SUBJECT_CODE"];
		$SUBJECT_DESCRIPTION = $arr_b["SUBJECT_DESCRIPTION"];
		$SUBJECT_LENGTH = $arr_b["SUBJECT_LENGTH"];
		$SUBJECT_FINAL_MARKS = $arr_b["SUBJECT_FINAL_MARKS"];
		$SUBJECT_GRADE = $arr_b["SUBJECT_GRADE"];
		$GRADING_POINT = $arr_b["GRADING_POINT"];
		$GRADING_KEY = $arr_b["GRADING_KEY"];

		$sql_subject_alias = "SELECT DISTINCT IFNULL(SUBJECT_ALIAS_CODE,' ') SUBJECT_ALIAS_CODE
			FROM SUBJECT_MASTER WHERE SUBJECT_KEY = $SUBJECT_KEY";
		$res88 = mysqli_query($con,$sql_subject_alias);
		$arr88 = mysqli_fetch_assoc($res88);
		$SUBJECT_ALIAS = $arr88["SUBJECT_ALIAS_CODE"];

		if ($SUBJECT_ALIAS == ' ')
		$SUBJECT_ALIAS_CODE = $SUBJECT_CODE;
		else
		$SUBJECT_ALIAS_CODE = $SUBJECT_ALIAS;

		if ($SUBJECT_CODE == 'SER1100' || $SUBJECT_CODE == 'SER1000' || $SUBJECT_CODE == 'SSC1010' || $SUBJECT_CODE == 'MPU1153' || $SUBJECT_CODE == 'MPU1133' ||
		$SUBJECT_CODE == 'GEN1020' || $SUBJECT_CODE == 'MPU 2213' || $SUBJECT_CODE == 'MPU 1133' || $SUBJECT_CODE == 'CFO')
		{
			$GRADING_POINT_DISP = 'N/A';
		}
		else
		{
			$GRADING_POINT_DISP = number_format($GRADING_POINT,1);
		}

		$CURRENT_GRADING_POINT = $CURRENT_GRADING_POINT + $GRADING_POINT;

		$SUBJECT_HTML .='<tr>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="5%">'.$V_RUNNING.'</td>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="15%">'.$SUBJECT_ALIAS_CODE.'</td>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="40%">'.$SUBJECT_DESCRIPTION.'</td>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="15%">'.number_format($SUBJECT_FINAL_MARKS).'</td>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="10%">'.$SUBJECT_GRADE.'</td>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="15%">'.$GRADING_POINT_DISP.'</td>
		</tr>';

		$V_RUNNING++;
	}

	$SUBJECT_FOOTER_HTML = "";
	for ($x=$V_RUNNING;$x<=10;$x++) 
	{
		$SUBJECT_FOOTER_HTML .= '<tr>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="5%"></td>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="15%"></td>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="40%"></td>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="15%"></td>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="10%"></td>
			<td align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;" width="15%"></td>
		</tr>';
	}

	$SUBJECT_SEMESTER_HTML = "";
	//if($LEVEL_CODE == 'CAL' || $LEVEL_CODE == 'PREPCAL')
	//{
		$SUBJECT_SEMESTER_HTML .='
		<tr>
        	<td>
        		<table cellspacing="" cellpadding="6" border="0" style="line-height:15px; width:100%; text-align:left;">
					<tr>
						<th><b>INTERPRETATION ( A Level Subject )</b></th>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td>
				<table cellspacing="" cellpadding="5" border="1" style="line-height:10px; width:90%; text-align:center;">';

		$sql_min_grading = "SELECT DISTINCT MIN(A.GRADING_KEY) AS MIN_GRADING_KEY
			FROM GRADING_DETAIL A, CUSTOMER_LEVEL_SUBJECT B WHERE A.GRADING_KEY = B.GRADING_KEY
			AND A.GRADING_CODE NOT LIKE '%MPU%' AND (B.LIT_KEY = $LIT_KEY) AND (B.CUSTOMER_KEY = $CUSTOMER_KEY)
			AND IFNULL(B.GRADING_KEY,0) <> 0 AND IFNULL(A.CALCULATION_INCLUDED,'N') = 'Y'";
		$res88 = mysqli_query($con,$sql_min_grading);
		$arr88 = mysqli_fetch_assoc($res88);
		$MIN_GRADING_KEY = $arr88["MIN_GRADING_KEY"];

		if (is_null($MIN_GRADING_KEY))
		$MIN_GRADING_KEY = 0;

		$sql_c = "SELECT DISTINCT GRADING_MARK_FROM, GRADING_MARK_TO, GRADING_GRADE, GRADING_POINT, GRADING_CODE
			FROM GRADING_DETAIL WHERE GRADING_KEY = $MIN_GRADING_KEY ORDER BY GRADING_MARK_TO DESC";

		for ($x = 1; $x <= 3; $x++) 
		{
			if($x == 1)
				$FIRST_COLUMN = "%";
			else if($x == 2)
				$FIRST_COLUMN = "Grade";
			else
				$FIRST_COLUMN = "Grade Point";

			$SUBJECT_SEMESTER_HTML .= '<tr>
				<th width="90"><b>'.$FIRST_COLUMN.'</b></th>';

			$result_c = mysqli_query($con,$sql_c)or die(mysqli_error($con));
			while($arr_c=mysqli_fetch_assoc($result_c))
			{
				$M_GRADING_MARK_FROM = $arr_c["GRADING_MARK_FROM"];
				$M_GRADING_MARK_TO = $arr_c["GRADING_MARK_TO"];
				$M_GRADING_GRADE = $arr_c["GRADING_GRADE"];
				$M_GRADING_POINT = $arr_c["GRADING_POINT"];
				$M_GRADING_CODE = $arr_c["GRADING_CODE"];

				if ($x == 1)
				$DISPLAY_COLUMN = number_format($M_GRADING_MARK_FROM)." - ".number_format($M_GRADING_MARK_TO);
				else if ($x == 2)
				$DISPLAY_COLUMN = $M_GRADING_GRADE;
				else
				$DISPLAY_COLUMN = number_format($M_GRADING_POINT,2);

				$SUBJECT_SEMESTER_HTML .= '<td>'.$DISPLAY_COLUMN.'</td>';
			}

			$SUBJECT_SEMESTER_HTML .= '</tr>';
		}
		$SUBJECT_SEMESTER_HTML .='</table></td></tr>';
	//}

	$SUBJECT_REPORT_HTML = "";
	//Start from here will be SUBJECT REPORT, each student will have multiple page
	$sql_d = "SELECT DISTINCT D.CUSTOMER_LIT_SUBJECT_KEY, D.SUBJECT_KEY, D.GROUP_KEY, D.SUBJECT_CODE, D.SUBJECT_DESCRIPTION, 
		D.SUBJECT_FINAL_MARKS, D.SUBJECT_GRADE, D.GRADING_POINT, D.GRADING_KEY
		FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_MASTER B, CUSTOMER_LEVEL_DETAILS C, CUSTOMER_LEVEL_SUBJECT D, 
		CUSTOMER_EXAM_MASTER E, EVALUATE_MASTER F
		WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY AND B.CUSTOMER_KEY = C.CUSTOMER_KEY AND B.LEVEL_KEY = C.LEVEL_KEY
		AND B.INTAKE_KEY = C.INTAKE_KEY AND C.CUSTOMER_LIT_KEY = D.CUSTOMER_LIT_KEY AND D.CUSTOMER_LIT_SUBJECT_KEY = E.CUSTOMER_LIT_SUBJECT_KEY AND E.EVALUATE_KEY = F.EVALUATE_KEY AND E.EVALUATE_MASTER_KEY = F.EVALUATE_MASTER_KEY
		AND C.CUSTOMER_LIT_KEY = $CUSTOMER_LIT_KEY AND C.LEVEL_CODE NOT IN ('PREPCAL')
		AND C.CUSTOMER_LEVEL_STATUS IN ('Active', 'Completed', 'Transfer In')
		AND D.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Resit', 'Repeat')
		AND D.SUBJECT_CODE NOT IN ('SER1100', 'SER1000', 'SSC1010', 'MPU1153', 'MPU1133', 'GEN1020', 'IELTS', 'TK', 'MPU 2213', 'MPU 1133', 'MUET') AND D.SUBJECT_CODE NOT LIKE 'ICDL%' AND D.SUBJECT_CODE NOT LIKE 'IVY%'
		AND (D.SUBJECT_KEY = $P_SUBJECT_KEY OR $P_SUBJECT_KEY IS NULL) AND (D.GROUP_KEY = $P_GROUP_KEY OR $P_GROUP_KEY IS NULL)
		ORDER BY D.SUBJECT_DESCRIPTION";
	$result_d = mysqli_query($con,$sql_d)or die(mysqli_error($con));
	while($arr_d = mysqli_fetch_assoc($result_d))
	{
		$CUSTOMER_LIT_SUBJECT_KEY = $arr_d["CUSTOMER_LIT_SUBJECT_KEY"];
		$SUBJECT_KEY = $arr_d["SUBJECT_KEY"];
		$GROUP_KEY = $arr_d["GROUP_KEY"];
		$SUBJECT_CODE = $arr_d["SUBJECT_CODE"];
		$SUBJECT_DESCRIPTION = $arr_d["SUBJECT_DESCRIPTION"];
		$SUBJECT_FINAL_MARKS = $arr_d["SUBJECT_FINAL_MARKS"];
		$SUBJECT_GRADE = $arr_d["SUBJECT_GRADE"];
		$GRADING_POINT = $arr_d["GRADING_POINT"];
		$GRADING_KEY = $arr_d["GRADING_KEY"];

		$LECTURER = "";

		$sql_lecturer = "SELECT DISTINCT LECTURER_NAME, LECTURER_MASTER FROM SUBJECT_LECTURER_DETAIL WHERE LIT_KEY = $LIT_KEY AND SUBJECT_KEY = $SUBJECT_KEY AND IFNULL(GROUP_KEY,0) = IFNULL($GROUP_KEY,0) ORDER BY IFNULL(LECTURER_MASTER,'N') DESC";
		$result_lecturer = mysqli_query($con,$sql_lecturer)or die(mysqli_error($con));
		while($arr_lecturer=mysqli_fetch_assoc($result_lecturer))
		{
			$LECTURER_NAME = $arr_lecturer["LECTURER_NAME"];

			if ($LECTURER == "")
				$LECTURER = $LECTURER_NAME;
			else
				$LECTURER = $LECTURER.', '.$LECTURER_NAME;
		}

		$V_SEQ = 1;
	  
		$sql_e = "SELECT DISTINCT E.EVALUATE_KEY, E.EVALUATE_MASTER_KEY, F.SEQ_NO, E.EVALUATE_TYPE, 
			IFNULL(E.EXAM_MARKS,-999) EXAM_MARKS, E.EVALUATE_PERCENTAGE, IFNULL(E.EXAM_REASON,'ZZZ') EXAM_REASON
			FROM CUSTOMER_INFO A, CUSTOMER_LEVEL_MASTER B, CUSTOMER_LEVEL_DETAILS C, CUSTOMER_LEVEL_SUBJECT D, 
			CUSTOMER_EXAM_MASTER E, EVALUATE_MASTER F
			WHERE A.CUSTOMER_KEY = B.CUSTOMER_KEY
			AND B.CUSTOMER_KEY = C.CUSTOMER_KEY
			AND B.LEVEL_KEY = C.LEVEL_KEY
			AND B.INTAKE_KEY = C.INTAKE_KEY
			AND C.CUSTOMER_LIT_KEY = D.CUSTOMER_LIT_KEY
			AND D.CUSTOMER_LIT_SUBJECT_KEY = E.CUSTOMER_LIT_SUBJECT_KEY
			AND E.EVALUATE_KEY = F.EVALUATE_KEY
			AND E.EVALUATE_MASTER_KEY = F.EVALUATE_MASTER_KEY
			AND D.CUSTOMER_LIT_SUBJECT_KEY = $CUSTOMER_LIT_SUBJECT_KEY
			AND C.CUSTOMER_LEVEL_STATUS IN ('Active', 'Completed', 'Transfer In')
			AND D.CUSTOMER_SUBJECT_STATUS IN ('Active', 'Completed', 'Resit', 'Repeat')
			AND D.SUBJECT_CODE NOT IN ('SER1100', 'SER1000', 'SSC1010', 'MPU1153', 'MPU1133', 'GEN1020', 'IELTS', 'TK', 'MPU 2213', 'MPU 1133', 'MUET')
			ORDER BY F.SEQ_NO, E.EVALUATE_TYPE";
		$result_e = mysqli_query($con,$sql_e)or die(mysqli_error($con));
		$SUBJECT_ASSESMENT_TABLE_REPORT_HTML = "";
		while($arr_e = mysqli_fetch_assoc($result_e))
		{
			$EVALUATE_KEY = $arr_e["EVALUATE_KEY"];
			$EVALUATE_MASTER_KEY = $arr_e["EVALUATE_MASTER_KEY"];
			$SEQ_NO = $arr_e["SEQ_NO"];
			$EVALUATE_TYPE = $arr_e["EVALUATE_TYPE"];
			$EXAM_MARKS = $arr_e["EXAM_MARKS"];
			$EVALUATE_PERCENTAGE = $arr_e["EVALUATE_PERCENTAGE"];
			$EXAM_REASON = $arr_e["EXAM_REASON"];

			$sql_weighting = "SELECT DISTINCT EVALUATE_PERCENTAGE, EXAM_MARKS FROM EVALUATE_MASTER
				WHERE EVALUATE_KEY = $EVALUATE_KEY AND EVALUATE_MASTER_KEY = $EVALUATE_MASTER_KEY";
			$res88 = mysqli_query($con,$sql_weighting);
			$arr88 = mysqli_fetch_assoc($res88);
			$WEIGHTING = $arr88["EVALUATE_PERCENTAGE"];
			$MAX_MARKS = $arr88["EXAM_MARKS"];

			if ($EXAM_MARKS == -999)
			{
			   $RAW_MARKS = "0";
			}
			else
			{
			   $RAW_MARKS = number_format($EXAM_MARKS,1);
			}

			if ($EXAM_REASON != 'ZZZ' && $EXAM_REASON != '')
			$RAW_MARKS = $RAW_MARKS.' ('.$EXAM_REASON.')';

			$SCALED_MARKS = $EVALUATE_PERCENTAGE;

			$SUBJECT_ASSESMENT_TABLE_REPORT_HTML .='
			<tr>
				<td align="center" width="5%">'.$V_SEQ.'</td>
				<td align="left" width="43%">'.$EVALUATE_TYPE.'</td>
				<td align="center" width="13%">'.number_format($WEIGHTING).'</td>
				<td align="center" width="13%">'.number_format($MAX_MARKS).'</td>
				<td align="center" width="13%">'.$RAW_MARKS.'</td>
				<td align="center" width="13%">'.number_format(round($SCALED_MARKS,1),2).'</td>
			</tr>';

			$V_SEQ++;
		}

		$SUBJECT_ASSESMENT_TABLE_FOOTER_REPORT_HTML = "";
		for ($x = $V_SEQ; $x <= 15; $x++) 
		{
			$SUBJECT_ASSESMENT_TABLE_FOOTER_REPORT_HTML .='<tr>
				<td align="center" width="5%"></td>
				<td align="left" width="43%"></td>
				<td align="center" width="13%"></td>
				<td align="center" width="13%"></td>
				<td align="center" width="13%"></td>
				<td align="center" width="13%"></td>
			</tr>';
		}

		$SUBJECT_ASSESMENT_TABLE_BOTTOM_FOOTER_REPORT_HTML = '
		<tr>
			<td>
				<table cellspacing="" cellpadding="6" border="0" style="line-height:15px; width:100%; text-align:left;">
					<tr>
						<th><b>INTERPRETATION</b></th>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td>
				<table cellspacing="" cellpadding="5" border="1" style="line-height:10px; width:90%; text-align:center;">';

		$sql_f = "SELECT DISTINCT GRADING_MARK_FROM, GRADING_MARK_TO, GRADING_GRADE, GRADING_POINT, GRADING_CODE
			FROM GRADING_DETAIL
			WHERE GRADING_KEY = $GRADING_KEY
			ORDER BY GRADING_MARK_TO DESC";
		for ($x = 1; $x <= 3; $x++) 
		{
			if ($x == 1)
				$FIRST_COLUMN = "%";
			else if ($x == 2)
				$FIRST_COLUMN = "Grade";
			else
				$FIRST_COLUMN = "Grade Point";

			$SUBJECT_ASSESMENT_TABLE_BOTTOM_FOOTER_REPORT_HTML .= '<tr><th width="90"><b>'.$FIRST_COLUMN.'</b></th>';

			$result_f = mysqli_query($con,$sql_f)or die(mysqli_error($con));
			while($arr_f=mysqli_fetch_assoc($result_f))
			{
				$D_GRADING_MARK_FROM = $arr_f["GRADING_MARK_FROM"];
				$D_GRADING_MARK_TO = $arr_f["GRADING_MARK_TO"];
				$D_GRADING_GRADE = $arr_f["GRADING_GRADE"];
				$D_GRADING_POINT = $arr_f["GRADING_POINT"];
				$D_GRADING_CODE = $arr_f["GRADING_CODE"];

				if ($x == 1)
					$DISPLAY_COLUMN = number_format($D_GRADING_MARK_FROM)." - ".number_format($D_GRADING_MARK_TO);
				else if ($x == 2)
					$DISPLAY_COLUMN = $D_GRADING_GRADE;
				else
					$DISPLAY_COLUMN = number_format($D_GRADING_POINT,2);

				$SUBJECT_ASSESMENT_TABLE_BOTTOM_FOOTER_REPORT_HTML .= '<td>'.$DISPLAY_COLUMN.'</td>';
			}
			$SUBJECT_ASSESMENT_TABLE_BOTTOM_FOOTER_REPORT_HTML .= '</tr>';
		}
		$SUBJECT_ASSESMENT_TABLE_BOTTOM_FOOTER_REPORT_HTML .= '</table></td></tr>';

		$SUBJECT_ASSESMENT_TABLE_BOTTOM_RESULT_CDOE_FOOTER_REPORT_HTML ='
		<tr>
			<td>
				<table cellspacing="" cellpadding="6" border="0" style="line-height:15px; width:100%; text-align:left;">
					<tr>
						<th><b>Result Code :</b></th>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td>
				<table cellspacing="" cellpadding="5" border="1" style="line-height:10px; width:30%; text-align:center;">
				
			';
		$sql_g = "SELECT DISTINCT LOV_NAME, LOV_DESCRIPTION
			FROM LOV_DETAIL WHERE LOV_VALUE = 'EXAM_REASON' ORDER BY LOV_NAME";

		for ($x = 1; $x <= 2; $x++) 
		{
			if ($x == 1)
			$FIRST_COLUMN = "Code";
			else
			$FIRST_COLUMN = "Description";

			$SUBJECT_ASSESMENT_TABLE_BOTTOM_RESULT_CDOE_FOOTER_REPORT_HTML .= '<tr>
					<th width="85"><b>'.$FIRST_COLUMN.'</b></th>';

			$result_g = mysqli_query($con,$sql_g)or die(mysqli_error($con));
			while($arr_g=mysqli_fetch_assoc($result_g))
			{
				$LOV_NAME = $arr_g["LOV_NAME"];
				$LOV_DESCRIPTION = $arr_g["LOV_DESCRIPTION"];

				if ($x == 1)
				$DISPLAY_COLUMN = $LOV_NAME;
				else
				$DISPLAY_COLUMN = $LOV_DESCRIPTION;

				$SUBJECT_ASSESMENT_TABLE_BOTTOM_RESULT_CDOE_FOOTER_REPORT_HTML .= '<td  width="80">'.$DISPLAY_COLUMN.'</td>';
			}
			
			$SUBJECT_ASSESMENT_TABLE_BOTTOM_RESULT_CDOE_FOOTER_REPORT_HTML .= '</tr>';
		}

		$SUBJECT_ASSESMENT_TABLE_BOTTOM_RESULT_CDOE_FOOTER_REPORT_HTML .='</table></td></tr>';

		$SUBJECT_REPORT_HTML .= '<br pagebreak="true" />
			<tr>
				<td>
					<table  cellspacing="" cellpadding="1" border="0" style="line-height:20px;width:100%;font-size:11px;">
						<tr>
							<td colspan="3" style="font-weight:bold;font-size:17px;line-height:50px;">SUBJECT REPORT</td>
						</tr>
						
						<tr>
							<td style="width:15%;"><strong>Name of Student</strong></td>
							<td style="width:3%">:</td>
							<td style="width:80%">'.$CUSTOMER_NAME.'</td>
						</tr>
						<tr>
							<td style="width:15%;"><strong>NRIC/Passport</strong></td>
							<td style="width:3%">:</td>
							<td>'.$IC_PASSPORT_DISPLAY.'</td>
						</tr>
						<tr>
							<td style="width:15%;"><strong>ID ( Cohort )</strong></td>
							<td style="width:3%">:</td>
							<td>'.$CUSTOMER_NO." ( ".$CLASS_CODE." )".'</td>
						</tr>
						<tr>
							<td style="width:15%;"><strong>Subject</strong></td>
							<td style="width:3%">:</td>
							<td>'.$SUBJECT_DESCRIPTION.'</td>
						</tr>
						<tr>
							<td style="width:15%;"><strong>Semester</strong></td>
							<td style="width:3%">:</td>
							<td>'.$SEMESTER_RANGE.'</td>
						</tr>
						<tr>
							<td style="width:15%;"><strong>Year of Entry</strong></td>
							<td style="width:3%">:</td>
							<td>'.$YEAR_OF_ENTRY.'</td>
						</tr>
						<tr>
							<td style="width:15%;"><strong>Lecturer</strong></td>
							<td style="width:3%">:</td>
							<td>'.$LECTURER.'</td>
						</tr>
					</table>
				</td>
			</tr>

			<tr style="line-height:20px;width:100%;font-size:11px;">
		      <td></td>
		    </tr>
			
		    <tr>
		    	<td>
					<table  cellspacing="" cellpadding="5" border="1" style="line-height:10px;">
						<thead>
							<tr>
								<th align="center" width="5%"><strong>No.</strong></th>
								<th align="center" width="43%"><strong>Assessment</strong></th>
								<th align="center" width="13%"><strong>Weighting</strong></th>
								<th align="center" width="13%"><strong>Max Marks</strong></th>
								<th align="center" width="13%"><strong>Raw Marks</strong></th>
								<th align="center" width="13%"><strong>Scaled Marks</strong></th>
							</tr>
						</thead>
						<tbody>
							'.$SUBJECT_ASSESMENT_TABLE_REPORT_HTML.'
							'.$SUBJECT_ASSESMENT_TABLE_FOOTER_REPORT_HTML.'
							<tr>
								<td align="center" width="5%"></td>
								<td align="center" width="43%"></td>
								<td align="center" width="13%"></td>
								<td align="center" width="13%"></td>
								<td align="center" width="13%"><b>Total</b></td>
								<td align="center" width="13%">'.number_format($SUBJECT_FINAL_MARKS).'</td>
							</tr>
							<tr>
								<td align="center" width="5%"></td>
								<td align="center" width="43%"></td>
								<td align="center" width="13%"></td>
								<td align="center" width="13%"></td>
								<td align="center" width="13%"><b>Grade</b></td>
								<td align="center" width="13%">'.$SUBJECT_GRADE.'</td>
							</tr>
							<tr>
								<td align="center" width="5%"></td>
								<td align="center" width="43%"></td>
								<td align="center" width="13%"></td>
								<td align="center" width="13%"></td>
								<td align="center" width="13%"><b>Grade Point</b></td>
								<td align="center" width="13%">'.number_format($GRADING_POINT,2).'</td>
							</tr>
							
						</tbody>
					</table>
				</td>
			</tr>


			<tr style="line-height:20px;width:100%;font-size:11px;">
		      <td></td>
		    </tr>
			
			'.$SUBJECT_ASSESMENT_TABLE_BOTTOM_FOOTER_REPORT_HTML.'
			
			<tr style="line-height:20px;width:100%;font-size:11px;">
		      <td></td>
		    </tr>

			'.$SUBJECT_ASSESMENT_TABLE_BOTTOM_RESULT_CDOE_FOOTER_REPORT_HTML.'
			
			';
	}

	$Style = "<br><br><br><br><br>";
	if($i>=1){
		$Style = "<br><br><br><br>";
	}

	$PageBrake = '';
	if($i!=0){
		$PageBrake = '<br pagebreak="true" />';
	}

	$tbl .= $PageBrake.'
	<table  cellspacing="" cellpadding="0" border="0" style="line-height:20px;width:100%;font-size:11px;">
		<tr>
			<td>
				<table  cellspacing="" cellpadding="0" border="0" style="line-height:20px;width:100%;font-size:11px;">
					<tr>
						<td colspan="3" style="font-weight:bold;font-size:17px;line-height:50px;">STATEMENT OF SEMESTER RESULTS</td>
					</tr>
					<tr>
						<td style="width:15%;"><strong>Name of Student</strong></td>
						<td style="width:3%">:</td>
						<td style="width:80%;">'.$CUSTOMER_NAME.'</td>
					</tr>
					<tr>
						<td style="width:15%;"><strong>NRIC/Passport</strong></td>
						<td style="width:3%">:</td>
						<td>'.$IC_PASSPORT_DISPLAY.'</td>
					</tr>
					<tr>
						<td style="width:15%;"><strong>ID ( Cohort )</strong></td>
						<td style="width:3%">:</td>
						<td>'.$CUSTOMER_NO." ( ".$CLASS_CODE." )".'</td>
					</tr>
					<tr>
						<td style="width:15%;"><strong>Semester</strong></td>
						<td style="width:3%">:</td>
						<td>'.$SEMESTER_RANGE.'</td>
					</tr>
					<tr>
						<td style="width:15%;"><strong>Year of Entry</strong></td>
						<td style="width:3%">:</td>
						<td>'.$YEAR_OF_ENTRY.'</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr style="line-height:20px;width:100%;font-size:11px;">
	      <td></td>
	    </tr>

		<tr>
			<td>
				<table  cellspacing="" cellpadding="3" border="0" style="line-height:25px;">
					<thead>
						<tr>
							<th align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="5%"><strong>No</strong></th>
							<th align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="15%"><strong>Subject Code</strong></th>
							<th align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="40%"><strong>Subject</strong></th>
							<th align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="15%"><strong>Total Marks</strong></th>
							<th align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="10%"><strong>Grade</strong></th>
							<th align="center" style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="15%"><strong>Grade Point</strong></th>
						</tr>
					</thead>
					<tbody>
						'.$SUBJECT_HTML.'
						'.$SUBJECT_FOOTER_HTML.'
						<tr>
							<td style="border-left: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="5%"></td>
							<td style="border-top: solid 2px #000;border-bottom: solid 2px #000;" width="15%"></td>
							<td style="border-top: solid 2px #000;border-bottom: solid 2px #000;" width="40%"></td>
							<td style="border-top: solid 2px #000;border-bottom: solid 2px #000;" width="15%"></td>
							<td style="border-top: solid 2px #000;border-bottom: solid 2px #000;" width="10%"></td>
							<td style="border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="15%"></td>
						</tr>
						<tr>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="75%" colspan="4" align="right"><strong>Total Grade Points This Semester</strong></td>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="10%"></td>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="15%" align="center">'.number_format($CURRENT_GRADING_POINT,1).'</td>
						</tr>
						<tr>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="75%" colspan="4" align="right"><strong>Cumulative Grade Points All Semesters</strong></td>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="10%"></td>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="15%" align="center">'.number_format($TOTAL_GRADING_POINTS,1).'</td>
						</tr>

						<tr>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="75%" rowspan="2" align="left">Overall Result :</td>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;text-align:right;" width="10%"><strong>GPA</strong></td>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="15%" align="center">'.number_format($GPA,2).'</td>
						</tr>
						<tr>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;text-align:right;" width="10%"><strong>CGPA</strong></td>
							<td style="border-left: solid 2px #000;border-right: solid 2px #000;border-top: solid 2px #000;border-bottom: solid 2px #000;" width="15%" align="center">'.number_format($CGPA,2).'</td>
						</tr>
					</tbody>
				</table>
			</td>
		</tr>

		'.$SUBJECT_SEMESTER_HTML.'
		
		<tr>
			<td>
				<table cellspacing="" cellpadding="6" border="0" style="line-height:15px; width:100%; text-align:left;">
					<tr><th><b>INTERPRETATION ( Compulsory Subject )</b></th></tr>
				</table>
			</td>
		</tr>

		<tr>
			<td>
				<table cellspacing="" cellpadding="5" border="1" style="line-height:10px; width:30%; text-align:center;">
					<tr><th width="90"><b>%</b></th><td>40 - 100</td><td>0 - 39</td></tr>
					<tr><th><b>Grade</b></th><td>Pass, P</td><td>Fail, F</td></tr>
				</table>
			</td>
		</tr>

	
		<tr style="line-height:70px;width:100%;font-size:11px;">
	      <td></td>
	    </tr>

	    <tr>
      		<td>
				<table cellspacing="" cellpadding="1" border="0" valing="bottom" style="line-height:1px; width:100%; text-align:center;    font-style: italic;">
				  <tr>
				    <th>*This is a computer generated document and NO signature is required.
				  </th>
				  </tr>
				</table>
			</td>
		</tr>
		'.$SUBJECT_REPORT_HTML.'
	</table>';

	$i++;
}

class MYPDF extends TCPDF {
    // Declare for use in all function
    protected $last_page = false;
    // Will be called at the end
    public function Close() {
        $this->last_page = true;
        parent::Close();
    }
    public $page_counter = 1;
    //Page header    
    var $top_margin = 90;
    
    //public $CAMPUS;

    public function Header() {
    	$this->top_margin = $this->GetY() + 28; // padding for second page
        
        global $CAMPUS;
        
        if ($CAMPUS == 'MCKL')
            $LOGO_IMAGE = 'MCKL_Logo1.png';
        else
            $LOGO_IMAGE = 'MCKL_Logo2.png';

    	$image_file = 'Image/'.$LOGO_IMAGE;
		$this->Image($image_file, 68, 5, 73, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);

		$this->SetFont('helvetica', 'B', 14);
		$this->writeHTMLCell('100','20','13','27','A - LEVEL', '', false, false, false, '',false);
    }

    // Page footer
    public function Footer() {

    }
}
// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->SetProtection(array('modify', 'copy', 'annot-forms', 'fill-forms', 'extract', 'assemble'), '', '[]mckl@0322741851&mcpg#042175088()', 3, null);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('');
$pdf->SetTitle('Statement of Semester Results for '.$CUSTOMER_NAME);
$pdf->SetSubject('Statement of Semester Results for '.$CUSTOMER_NAME);
$pdf->SetKeywords('Statement of Semester Results for '.$CUSTOMER_NAME);

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, '5');

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}
// ---------------------------------------------------------
// $pdf->SetMargins(10, 50, 0, true); // put space of 10 on top 
// add a page
$pdf->AddPage('P','A4');
// set color for background
$pdf->SetFillColor(255, 255, 127);
// set font

$pdf->SetMargins(15, $pdf->top_margin, 10);
$pdf->SetFont('helvetica', 'S', 9);
$pdf->writeHTMLCell('','0','12', '33' ,$tbl, '', '15', false, false, '',false);
//$pdf->writeHTMLCell($w=0, $h=0, $x='', $y='', $html, $border=0, $ln=1, $fill=0, $reseth=true, $align='', $autopadding=true);

$report_name = preg_replace('/[^a-zA-Z0-9_ -]/s', '', $CUSTOMER_NAME);

$pdf->lastPage();
$pdf->Output($report_name.'.pdf', 'I');
?>