<?php
//If the HTTPS is not found to be "on"
if(!isset($_SERVER["HTTPS"]) || $_SERVER["HTTPS"] != "on")
{
    //Tell the browser to redirect to the HTTPS URL.
    header("Location: https://" . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"], true, 301);
    //Prevent the rest of the script from executing.
    exit;
}

include "db_config.php";

$sql_system = "SELECT DISTINCT SYSTEM_NAME, SYSTEM_SIGNIN_LOGO 
               FROM SYSTEM_INFO
               WHERE SYSTEM_KEY = (SELECT MIN(SYSTEM_KEY) FROM SYSTEM_INFO)";
$res_system = mysqli_query($con,$sql_system);
$arr_system = mysqli_fetch_assoc($res_system);
$SYSTEM_NAME = $arr_system["SYSTEM_NAME"];
$SYSTEM_SIGNIN_LOGO = $arr_system["SYSTEM_SIGNIN_LOGO"];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="robots" content="noindex, nofollow">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $SYSTEM_NAME; ?> - Admin | Sign In</title>
    
    <link rel="shortcut icon" href="#" />
    
    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/adminlte.min.css">
    
    <script src="plugins/jquery/jquery.min.js"></script>
    
    <style type="text/css">
        .loader {
            position: fixed;
            left: 0px;
            top: 0px;
            width: 100%;
            height: 100%;
            z-index: 9999;
            background: url('Image/loader.gif') 50% 50% no-repeat rgb(249,249,249);
            opacity: .9;
        }
    </style>
</head>
<body class="hold-transition login-page">
    <div class="loader" style="display: none;"></div>
    <div class="login-box">
    <!-- /.login-logo -->
        <div class="card card-outline card-primary">
            <div class="card-header text-center" style="margin-top: 16px; width: 100%">
                <img src="<?php echo $SYSTEM_SIGNIN_LOGO; ?>" style="width: 100%">
                <br /><br />
                <span class="h1">
                    <b>Admin</b> Sign In
                </span>
                <br /><br />
                <span class="h4" style="Color:blue;">
                    <b>Lecturer & Course Evaluation<br />Management System</b>
                </span>
                <br /><br />
            </div>
            <div class="card-body">
                <p class="login-box-msg">Please Sign In to Start Your Session</p>
                
                <div class="input-group mb-3">
                    <input type="text" class="form-control" name="signin_username" id="signin_username" placeholder="Sign In Username" autocomplete="username" oninput="this.value = this.value.toUpperCase()" autofocus>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <input type="password" class="form-control" name="signin_password" id="signin_password" placeholder="Sign In Password" autocomplete="new-password">
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-lock"></span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <button type="button" id="btn_sign_in" class="btn btn-lg btn-primary btn-block">Sign In</button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        &nbsp;
                    </div>
                </div>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
    <!-- /.login-box -->
    
    <!-- jQuery -->
    <script src="plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap 4 -->
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- AdminLTE App -->
    <script src="dist/js/adminlte.min.js"></script>
</body>
</html>


<script type="text/javascript">
$(document).ready(function () {
    $(document).on('click', '#btn_sign_in', function() {
        //alert("Clicked Sign In");
        //v_username = document.getElementById('signin_username').value;
        //v_password = document.getElementById('signin_password').value;
        //alert(v_username);
        //alert(v_password);
        
        var LOGIN_USERNAME = $("#signin_username").val();
        var LOGIN_PASSWORD = $("#signin_password").val();
        var LOGIN_ERROR = 0;
        var LOGIN_ERROR_MSG = "Please Enter Following Field(s) before Sign In:\n";
        
        if (LOGIN_USERNAME == "" || LOGIN_USERNAME == " " || LOGIN_USERNAME == null)
        {
            LOGIN_ERROR_MSG = LOGIN_ERROR_MSG+"- Sign In Username\n";
            LOGIN_ERROR = LOGIN_ERROR + 1;
        }
        
        if (LOGIN_PASSWORD == "" || LOGIN_PASSWORD == " " || LOGIN_PASSWORD == null)
        {
            LOGIN_ERROR_MSG = LOGIN_ERROR_MSG+"- Sign In Password\n";
            LOGIN_ERROR = LOGIN_ERROR + 1;
        }
        
        if (LOGIN_ERROR == 0)
        {
            $.ajax({
                type: 'POST',
                url:'admin_login_verify.php',
                data :{
                    'LOGIN_USERNAME':LOGIN_USERNAME, 
                    'LOGIN_PASSWORD':LOGIN_PASSWORD
                },
                dataType: 'JSON',
                cache: false,
                beforeSend: function(){
                    $('.loader').show();
                },
                complete: function(){
                    $('.loader').hide();
                },
                success: function(response){
                    if (response.return_message == "Sign In Successful") {
                        //$('body').hide();
                        $('div').hide();
                        $('.loader').show();
                        window.location.replace("admin_login_ps.php?lkey="+btoa(response.return_userkey));
                    }
                    else
                    {
                        alert(response.return_message);
                        
                        document.getElementById("signin_username").focus();
                    }
                    //alert("123");
                    //alert(response.message);
                    //alert(response.return_value);
                    //window.location.reload();
                    //window.location.replace("index.php?page=new_offer_letter_print&cokey="+btoa(P_CUSTOMER_OFFER_KEY));
                },
            });
        }
        else
        {
            alert(LOGIN_ERROR_MSG);
            return false;
        }
    });
});
</script>